/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import org.apache.tika.exception.TikaException;

public class TemporaryResources
implements Closeable {
    private final LinkedList<Closeable> resources = new LinkedList();
    private Path tempFileDir = null;

    public void setTemporaryFileDirectory(Path path) {
        this.tempFileDir = path;
    }

    public void setTemporaryFileDirectory(File file) {
        this.tempFileDir = file == null ? null : file.toPath();
    }

    public Path createTempFile() throws IOException {
        final Path path = this.tempFileDir == null ? Files.createTempFile("apache-tika-", ".tmp", new FileAttribute[0]) : Files.createTempFile(this.tempFileDir, "apache-tika-", ".tmp", new FileAttribute[0]);
        this.addResource(new Closeable(){

            @Override
            public void close() throws IOException {
                Files.delete(path);
            }
        });
        return path;
    }

    public File createTemporaryFile() throws IOException {
        return this.createTempFile().toFile();
    }

    public void addResource(Closeable closeable) {
        this.resources.addFirst(closeable);
    }

    public <T extends Closeable> T getResource(Class<T> clazz) {
        for (Closeable closeable : this.resources) {
            if (!clazz.isAssignableFrom(closeable.getClass())) continue;
            return (T)closeable;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        IOException iOException = null;
        for (Closeable closeable : this.resources) {
            try {
                closeable.close();
            }
            catch (IOException iOException2) {
                if (iOException == null) {
                    iOException = iOException2;
                    continue;
                }
                iOException.addSuppressed(iOException2);
            }
        }
        this.resources.clear();
        if (iOException != null) {
            throw iOException;
        }
    }

    public void dispose() throws TikaException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            throw new TikaException("Failed to close temporary resources", iOException);
        }
    }
}

