/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.tika.io.TaggedInputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.metadata.Metadata;

public class TikaInputStream
extends TaggedInputStream {
    private static final int BLOB_SIZE_THRESHOLD = 0x100000;
    private Path path;
    private final TemporaryResources tmp;
    private long length;
    private long position = 0L;
    private long mark = -1L;
    private Object openContainer;

    public static boolean isTikaInputStream(InputStream inputStream) {
        return inputStream instanceof TikaInputStream;
    }

    public static TikaInputStream get(InputStream inputStream, TemporaryResources temporaryResources) {
        if (inputStream == null) {
            throw new NullPointerException("The Stream must not be null");
        }
        if (inputStream instanceof TikaInputStream) {
            return (TikaInputStream)inputStream;
        }
        if (!(inputStream instanceof BufferedInputStream) && !(inputStream instanceof ByteArrayInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return new TikaInputStream(inputStream, temporaryResources, -1L);
    }

    public static TikaInputStream get(InputStream inputStream) {
        return TikaInputStream.get(inputStream, new TemporaryResources());
    }

    public static TikaInputStream cast(InputStream inputStream) {
        if (inputStream instanceof TikaInputStream) {
            return (TikaInputStream)inputStream;
        }
        return null;
    }

    public static TikaInputStream get(byte[] byArray) {
        return TikaInputStream.get(byArray, new Metadata());
    }

    public static TikaInputStream get(byte[] byArray, Metadata metadata) {
        metadata.set("Content-Length", Integer.toString(byArray.length));
        return new TikaInputStream(new ByteArrayInputStream(byArray), new TemporaryResources(), byArray.length);
    }

    public static TikaInputStream get(Path path) throws IOException {
        return TikaInputStream.get(path, new Metadata());
    }

    public static TikaInputStream get(Path path, Metadata metadata) throws IOException {
        metadata.set("resourceName", path.getFileName().toString());
        metadata.set("Content-Length", Long.toString(Files.size(path)));
        return new TikaInputStream(path);
    }

    @Deprecated
    public static TikaInputStream get(File file) throws FileNotFoundException {
        return TikaInputStream.get(file, new Metadata());
    }

    @Deprecated
    public static TikaInputStream get(File file, Metadata metadata) throws FileNotFoundException {
        metadata.set("resourceName", file.getName());
        metadata.set("Content-Length", Long.toString(file.length()));
        return new TikaInputStream(file);
    }

    public static TikaInputStream get(Blob blob) throws SQLException {
        return TikaInputStream.get(blob, new Metadata());
    }

    public static TikaInputStream get(Blob blob, Metadata metadata) throws SQLException {
        long l = -1L;
        try {
            l = blob.length();
            metadata.set("Content-Length", Long.toString(l));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (0L <= l && l <= 0x100000L) {
            return TikaInputStream.get(blob.getBytes(1L, (int)l), metadata);
        }
        return new TikaInputStream(new BufferedInputStream(blob.getBinaryStream()), new TemporaryResources(), l);
    }

    public static TikaInputStream get(URI uRI) throws IOException {
        return TikaInputStream.get(uRI, new Metadata());
    }

    public static TikaInputStream get(URI uRI, Metadata metadata) throws IOException {
        Path path;
        if ("file".equalsIgnoreCase(uRI.getScheme()) && Files.isRegularFile(path = Paths.get(uRI), new LinkOption[0])) {
            return TikaInputStream.get(path, metadata);
        }
        return TikaInputStream.get(uRI.toURL(), metadata);
    }

    public static TikaInputStream get(URL uRL) throws IOException {
        return TikaInputStream.get(uRL, new Metadata());
    }

    public static TikaInputStream get(URL uRL, Metadata metadata) throws IOException {
        int n;
        String string;
        String string2;
        Object object;
        if ("file".equalsIgnoreCase(uRL.getProtocol())) {
            try {
                object = Paths.get(uRL.toURI());
                if (Files.isRegularFile((Path)object, new LinkOption[0])) {
                    return TikaInputStream.get((Path)object, metadata);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        object = uRL.openConnection();
        String string3 = uRL.getPath();
        int n2 = string3.lastIndexOf(47);
        if (n2 + 1 < string3.length()) {
            metadata.set("resourceName", string3.substring(n2 + 1));
        }
        if ((string2 = ((URLConnection)object).getContentType()) != null) {
            metadata.set("Content-Type", string2);
        }
        if ((string = ((URLConnection)object).getContentEncoding()) != null) {
            metadata.set("Content-Encoding", string);
        }
        if ((n = ((URLConnection)object).getContentLength()) >= 0) {
            metadata.set("Content-Length", Integer.toString(n));
        }
        return new TikaInputStream(new BufferedInputStream(((URLConnection)object).getInputStream()), new TemporaryResources(), n);
    }

    private TikaInputStream(Path path) throws IOException {
        super(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
        this.path = path;
        this.tmp = new TemporaryResources();
        this.length = Files.size(path);
    }

    @Deprecated
    private TikaInputStream(File file) throws FileNotFoundException {
        super(new BufferedInputStream(new FileInputStream(file)));
        this.path = file.toPath();
        this.tmp = new TemporaryResources();
        this.length = file.length();
    }

    private TikaInputStream(InputStream inputStream, TemporaryResources temporaryResources, long l) {
        super(inputStream);
        this.path = null;
        this.tmp = temporaryResources;
        this.length = l;
    }

    public int peek(byte[] byArray) throws IOException {
        int n = 0;
        this.mark(byArray.length);
        int n2 = this.read(byArray);
        while (n2 != -1) {
            if ((n += n2) < byArray.length) {
                n2 = this.read(byArray, n, byArray.length - n);
                continue;
            }
            n2 = -1;
        }
        this.reset();
        return n;
    }

    public Object getOpenContainer() {
        return this.openContainer;
    }

    public void setOpenContainer(Object object) {
        this.openContainer = object;
        if (object instanceof Closeable) {
            this.tmp.addResource((Closeable)object);
        }
    }

    public boolean hasFile() {
        return this.path != null;
    }

    public Path getPath() throws IOException {
        if (this.path == null) {
            if (this.position > 0L) {
                throw new IOException("Stream is already being read");
            }
            this.path = this.tmp.createTempFile();
            Files.copy(this.in, this.path, StandardCopyOption.REPLACE_EXISTING);
            InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);
            this.tmp.addResource(inputStream);
            final InputStream inputStream2 = this.in;
            this.in = new BufferedInputStream(this, inputStream){

                @Override
                public void close() throws IOException {
                    inputStream2.close();
                }
            };
            this.length = Files.size(this.path);
        }
        return this.path;
    }

    public File getFile() throws IOException {
        return this.getPath().toFile();
    }

    public FileChannel getFileChannel() throws IOException {
        FileChannel fileChannel = FileChannel.open(this.getPath(), new OpenOption[0]);
        this.tmp.addResource(fileChannel);
        return fileChannel;
    }

    public boolean hasLength() {
        return this.length != -1L;
    }

    public long getLength() throws IOException {
        if (this.length == -1L) {
            this.getPath();
        }
        return this.length;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.position += l2;
        return l2;
    }

    @Override
    public void mark(int n) {
        super.mark(n);
        this.mark = this.position;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.position = this.mark;
        this.mark = -1L;
    }

    @Override
    public void close() throws IOException {
        this.path = null;
        this.mark = -1L;
        this.tmp.addResource(this.in);
        this.tmp.close();
    }

    @Override
    protected void afterRead(int n) {
        if (n != -1) {
            this.position += (long)n;
        }
    }

    @Override
    public String toString() {
        Object object = "TikaInputStream of ";
        object = this.hasFile() ? (String)object + this.path.toString() : (String)object + this.in.toString();
        if (this.openContainer != null) {
            object = (String)object + " (in " + String.valueOf(this.openContainer) + ")";
        }
        return object;
    }
}

