/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tika.language.LanguageProfile;

@Deprecated
public class LanguageIdentifier {
    private static final Map<String, LanguageProfile> PROFILES = new HashMap<String, LanguageProfile>();
    private static final String PROFILE_SUFFIX = ".ngp";
    private static Properties props = new Properties();
    private static String errors = "";
    private static final String PROPERTIES_OVERRIDE_FILE = "tika.language.override.properties";
    private static final String PROPERTIES_FILE = "tika.language.properties";
    private static final String LANGUAGES_KEY = "languages";
    private static final double CERTAINTY_LIMIT = 0.022;
    private final String language;
    private final double distance;

    private static void addProfile(String string) throws Exception {
        try {
            LanguageProfile languageProfile = new LanguageProfile();
            try (InputStream inputStream = LanguageIdentifier.class.getResourceAsStream(string + PROFILE_SUFFIX);){
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (string2.length() > 0 && !string2.startsWith("#")) {
                        int n = string2.indexOf(32);
                        languageProfile.add(string2.substring(0, n), Long.parseLong(string2.substring(n + 1)));
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            LanguageIdentifier.addProfile(string, languageProfile);
        }
        catch (Throwable throwable) {
            throw new Exception("Failed trying to load language profile for language \"" + string + "\". Error: " + throwable.getMessage());
        }
    }

    public static void addProfile(String string, LanguageProfile languageProfile) {
        PROFILES.put(string, languageProfile);
    }

    public LanguageIdentifier(LanguageProfile languageProfile) {
        String string = "unknown";
        double d = 1.0;
        for (Map.Entry<String, LanguageProfile> entry : PROFILES.entrySet()) {
            double d2 = languageProfile.distance(entry.getValue());
            if (!(d2 < d)) continue;
            d = d2;
            string = entry.getKey();
        }
        this.language = string;
        this.distance = d;
    }

    public LanguageIdentifier(String string) {
        this(new LanguageProfile(string));
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isReasonablyCertain() {
        return this.distance < 0.022;
    }

    public static void initProfiles() {
        String[] stringArray;
        LanguageIdentifier.clearProfiles();
        errors = "";
        InputStream inputStream = LanguageIdentifier.class.getResourceAsStream(PROPERTIES_OVERRIDE_FILE);
        if (inputStream == null) {
            inputStream = LanguageIdentifier.class.getResourceAsStream(PROPERTIES_FILE);
        }
        if (inputStream != null) {
            try {
                props = new Properties();
                props.load(inputStream);
            }
            catch (IOException iOException) {
                errors = errors + "IOException while trying to load property file. Message: " + iOException.getMessage() + "\n";
            }
        }
        for (String string : stringArray = props.getProperty(LANGUAGES_KEY).split(",")) {
            string = string.trim();
            String string2 = props.getProperty("name." + string, "Unknown");
            try {
                LanguageIdentifier.addProfile(string);
            }
            catch (Exception exception) {
                errors = errors + "Language " + string + " (" + string2 + ") not initialized. Message: " + exception.getMessage() + "\n";
            }
        }
    }

    public static void initProfiles(Map<String, LanguageProfile> map) {
        LanguageIdentifier.clearProfiles();
        for (Map.Entry<String, LanguageProfile> entry : map.entrySet()) {
            LanguageIdentifier.addProfile(entry.getKey(), entry.getValue());
        }
    }

    public static void clearProfiles() {
        PROFILES.clear();
    }

    public static boolean hasErrors() {
        return errors != "";
    }

    public static String getErrors() {
        return errors;
    }

    public static Set<String> getSupportedLanguages() {
        return PROFILES.keySet();
    }

    public String toString() {
        return this.language + " (" + this.distance + ")";
    }

    static {
        LanguageIdentifier.initProfiles();
    }
}

