/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tika.exception.TikaException;

@Deprecated
public class LanguageProfilerBuilder {
    static final int ABSOLUTE_MIN_NGRAM_LENGTH = 3;
    static final int ABSOLUTE_MAX_NGRAM_LENGTH = 3;
    static final int DEFAULT_MIN_NGRAM_LENGTH = 3;
    static final int DEFAULT_MAX_NGRAM_LENGTH = 3;
    static final String FILE_EXTENSION = "ngp";
    static final int MAX_SIZE = 1000;
    static final char SEPARATOR = '_';
    private static final String SEP_CHARSEQ = new String(new char[]{'_'});
    private String name = null;
    private List<NGramEntry> sorted = null;
    private int minLength = 3;
    private int maxLength = 3;
    private int[] ngramcounts = null;
    private Map<CharSequence, NGramEntry> ngrams = null;
    private QuickStringBuffer word = new QuickStringBuffer();

    public LanguageProfilerBuilder(String string, int n, int n2) {
        this.ngrams = new HashMap<CharSequence, NGramEntry>(4000);
        this.minLength = n;
        this.maxLength = n2;
        this.name = string;
    }

    public LanguageProfilerBuilder(String string) {
        this.ngrams = new HashMap<CharSequence, NGramEntry>(4000);
        this.minLength = 3;
        this.maxLength = 3;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void add(StringBuffer stringBuffer) {
        for (int i = this.minLength; i <= this.maxLength && i < stringBuffer.length(); ++i) {
            this.add(stringBuffer, i);
        }
    }

    private void add(QuickStringBuffer quickStringBuffer) {
        int n = quickStringBuffer.length();
        if (n >= this.minLength) {
            int n2 = Math.min(this.maxLength, n);
            for (int i = this.minLength; i <= n2; ++i) {
                this.add(quickStringBuffer.subSequence(n - i, n));
            }
        }
    }

    private void add(CharSequence charSequence) {
        if (charSequence.equals(SEP_CHARSEQ)) {
            return;
        }
        NGramEntry nGramEntry = this.ngrams.get(charSequence);
        if (nGramEntry == null) {
            nGramEntry = new NGramEntry(charSequence);
            this.ngrams.put(charSequence, nGramEntry);
        }
        nGramEntry.inc();
    }

    public void analyze(StringBuilder stringBuilder) {
        if (this.ngrams != null) {
            this.ngrams.clear();
            this.sorted = null;
            this.ngramcounts = null;
        }
        this.word.clear().append('_');
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = Character.toLowerCase(stringBuilder.charAt(i));
            if (Character.isLetter(c)) {
                this.add(this.word.append(c));
                continue;
            }
            if (this.word.length() <= 1) continue;
            this.add(this.word.append('_'));
            this.word.clear().append('_');
        }
        if (this.word.length() > 1) {
            this.add(this.word.append('_'));
        }
        this.normalize();
    }

    private void add(StringBuffer stringBuffer, int n) {
        for (int i = 0; i <= stringBuffer.length() - n; ++i) {
            this.add(stringBuffer.subSequence(i, i + n));
        }
    }

    protected void normalize() {
        NGramEntry nGramEntry2 = null;
        Iterator<NGramEntry> iterator = this.ngrams.values().iterator();
        if (this.ngramcounts == null) {
            this.ngramcounts = new int[this.maxLength + 1];
            while (iterator.hasNext()) {
                nGramEntry2 = iterator.next();
                int n = nGramEntry2.size();
                this.ngramcounts[n] = this.ngramcounts[n] + nGramEntry2.count;
            }
        }
        for (NGramEntry nGramEntry2 : this.ngrams.values()) {
            nGramEntry2.frequency = (float)nGramEntry2.count / (float)this.ngramcounts[nGramEntry2.size()];
        }
    }

    public List<NGramEntry> getSorted() {
        if (this.sorted == null) {
            this.sorted = new ArrayList<NGramEntry>(this.ngrams.values());
            Collections.sort(this.sorted);
            if (this.sorted.size() > 1000) {
                this.sorted = this.sorted.subList(0, 1000);
            }
        }
        return this.sorted;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("NGramProfile: ").append(this.name).append("\n");
        for (NGramEntry nGramEntry : this.getSorted()) {
            stringBuffer.append("[").append(nGramEntry.seq).append("/").append(nGramEntry.count).append("/").append(nGramEntry.frequency).append("]\n");
        }
        return stringBuffer.toString();
    }

    public float getSimilarity(LanguageProfilerBuilder languageProfilerBuilder) throws TikaException {
        float f = 0.0f;
        try {
            for (NGramEntry nGramEntry : languageProfilerBuilder.getSorted()) {
                if (this.ngrams.containsKey(nGramEntry.seq)) {
                    f += Math.abs(nGramEntry.frequency - this.ngrams.get((Object)nGramEntry.seq).frequency) / 2.0f;
                    continue;
                }
                f += nGramEntry.frequency;
            }
            for (NGramEntry nGramEntry : this.getSorted()) {
                if (languageProfilerBuilder.ngrams.containsKey(nGramEntry.seq)) {
                    f += Math.abs(nGramEntry.frequency - languageProfilerBuilder.ngrams.get((Object)nGramEntry.seq).frequency) / 2.0f;
                    continue;
                }
                f += nGramEntry.frequency;
            }
        }
        catch (Exception exception) {
            throw new TikaException("Could not calculate a score how well NGramProfiles match each other");
        }
        return f;
    }

    public void load(InputStream inputStream) throws IOException {
        this.ngrams.clear();
        this.ngramcounts = new int[this.maxLength + 1];
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            String string2;
            int n2;
            if (string.charAt(0) == '#' || (n2 = (string2 = string.substring(0, n = string.indexOf(32)).trim()).length()) < this.minLength || n2 > this.maxLength) continue;
            int n3 = Integer.parseInt(string.substring(n + 1));
            NGramEntry nGramEntry = new NGramEntry(string2, n3);
            this.ngrams.put(nGramEntry.getSeq(), nGramEntry);
            int n4 = n2;
            this.ngramcounts[n4] = this.ngramcounts[n4] + n3;
        }
        this.normalize();
    }

    public static LanguageProfilerBuilder create(String string, InputStream inputStream, String string2) throws TikaException {
        LanguageProfilerBuilder languageProfilerBuilder = new LanguageProfilerBuilder(string, 3, 3);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] byArray = new byte[4096];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                stringBuilder.append(new String(byArray, 0, n, string2));
            }
        }
        catch (IOException iOException) {
            throw new TikaException("Could not create profile, " + iOException.getMessage());
        }
        languageProfilerBuilder.analyze(stringBuilder);
        return languageProfilerBuilder;
    }

    public void save(OutputStream outputStream) throws IOException {
        int n;
        outputStream.write(("# NgramProfile generated at " + String.valueOf(new Date()) + " for Apache Tika Language Identification\n").getBytes(StandardCharsets.UTF_8));
        ArrayList arrayList = new ArrayList();
        List list = new ArrayList<NGramEntry>();
        NGramEntry[] nGramEntryArray = this.ngrams.values().toArray(new NGramEntry[this.ngrams.size()]);
        for (n = this.minLength; n <= this.maxLength; ++n) {
            for (int i = 0; i < nGramEntryArray.length; ++i) {
                if (nGramEntryArray[i].getSeq().length() != n) continue;
                list.add(nGramEntryArray[i]);
            }
            Collections.sort(list);
            if (list.size() > 1000) {
                list = list.subList(0, 1000);
            }
            arrayList.addAll(list);
            list.clear();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            NGramEntry nGramEntry = (NGramEntry)arrayList.get(n);
            String string = nGramEntry.toString() + " " + nGramEntry.getCount() + "\n";
            outputStream.write(string.getBytes(StandardCharsets.UTF_8));
        }
        outputStream.flush();
    }

    public static void main(String[] stringArray) {
        String string = "Usage: NGramProfile [-create profilename filename encoding] [-similarity file1 file2] [-score profile-name filename encoding]";
        int n = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (stringArray.length == 0) {
            System.err.println(string);
            System.exit(-1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-create")) {
                n = 1;
                string2 = stringArray[++i];
                string3 = stringArray[++i];
                string5 = stringArray[++i];
            }
            if (stringArray[i].equals("-similarity")) {
                n = 2;
                string3 = stringArray[++i];
                string4 = stringArray[++i];
                string5 = stringArray[++i];
            }
            if (!stringArray[i].equals("-score")) continue;
            n = 3;
            string2 = stringArray[++i];
            string3 = stringArray[++i];
            string5 = stringArray[++i];
        }
        try {
            switch (n) {
                case 1: {
                    File file = new File(string3);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    LanguageProfilerBuilder languageProfilerBuilder = LanguageProfilerBuilder.create(string2, fileInputStream, string5);
                    fileInputStream.close();
                    file = new File(string2 + ".ngp");
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    languageProfilerBuilder.save(fileOutputStream);
                    System.out.println("new profile " + string2 + ".ngp was created.");
                    break;
                }
                case 2: {
                    File file = new File(string3);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    LanguageProfilerBuilder languageProfilerBuilder = LanguageProfilerBuilder.create(string3, fileInputStream, string5);
                    languageProfilerBuilder.normalize();
                    file = new File(string4);
                    fileInputStream = new FileInputStream(file);
                    LanguageProfilerBuilder languageProfilerBuilder2 = LanguageProfilerBuilder.create(string4, fileInputStream, string5);
                    languageProfilerBuilder2.normalize();
                    System.out.println("Similarity is " + languageProfilerBuilder.getSimilarity(languageProfilerBuilder2));
                    break;
                }
                case 3: {
                    File file = new File(string3);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    LanguageProfilerBuilder languageProfilerBuilder = LanguageProfilerBuilder.create(string3, fileInputStream, string5);
                    file = new File(string2 + ".ngp");
                    fileInputStream = new FileInputStream(file);
                    LanguageProfilerBuilder languageProfilerBuilder3 = new LanguageProfilerBuilder(string2, 3, 3);
                    languageProfilerBuilder3.load(fileInputStream);
                    System.out.println("Score is " + languageProfilerBuilder3.getSimilarity(languageProfilerBuilder));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class QuickStringBuffer
    implements CharSequence {
        private char[] value;
        private int count;

        QuickStringBuffer() {
            this(16);
        }

        QuickStringBuffer(char[] cArray) {
            this.value = cArray;
            this.count = cArray.length;
        }

        QuickStringBuffer(int n) {
            this.value = new char[n];
        }

        QuickStringBuffer(String string) {
            this(string.length() + 16);
            this.append(string);
        }

        @Override
        public int length() {
            return this.count;
        }

        private void expandCapacity(int n) {
            int n2 = (this.value.length + 1) * 2;
            if (n2 < 0) {
                n2 = Integer.MAX_VALUE;
            } else if (n > n2) {
                n2 = n;
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }

        QuickStringBuffer clear() {
            this.count = 0;
            return this;
        }

        @Override
        public char charAt(int n) {
            return this.value[n];
        }

        QuickStringBuffer append(String string) {
            int n;
            int n2;
            if (string == null) {
                string = String.valueOf(string);
            }
            if ((n2 = this.count + (n = string.length())) > this.value.length) {
                this.expandCapacity(n2);
            }
            string.getChars(0, n, this.value, this.count);
            this.count = n2;
            return this;
        }

        QuickStringBuffer append(char c) {
            int n = this.count + 1;
            if (n > this.value.length) {
                this.expandCapacity(n);
            }
            this.value[this.count++] = c;
            return this;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return new String(this.value, n, n2 - n);
        }

        @Override
        public String toString() {
            return new String(this.value);
        }
    }

    static class NGramEntry
    implements Comparable<NGramEntry> {
        private LanguageProfilerBuilder profile = null;
        CharSequence seq = null;
        private int count = 0;
        private float frequency = 0.0f;

        public NGramEntry(CharSequence charSequence) {
            this.seq = charSequence;
        }

        public NGramEntry(String string, int n) {
            this.seq = new StringBuffer(string).subSequence(0, string.length());
            this.count = n;
        }

        public int getCount() {
            return this.count;
        }

        public float getFrequency() {
            return this.frequency;
        }

        public CharSequence getSeq() {
            return this.seq;
        }

        public int size() {
            return this.seq.length();
        }

        @Override
        public int compareTo(NGramEntry nGramEntry) {
            int n = Float.compare(nGramEntry.getFrequency(), this.frequency);
            if (n != 0) {
                return n;
            }
            return this.toString().compareTo(nGramEntry.toString());
        }

        public void inc() {
            ++this.count;
        }

        public void setProfile(LanguageProfilerBuilder languageProfilerBuilder) {
            this.profile = languageProfilerBuilder;
        }

        public LanguageProfilerBuilder getProfile() {
            return this.profile;
        }

        public String toString() {
            return this.seq.toString();
        }

        public int hashCode() {
            return this.seq.hashCode();
        }

        public boolean equals(Object object) {
            NGramEntry nGramEntry = null;
            try {
                nGramEntry = (NGramEntry)object;
                return nGramEntry.seq.equals(this.seq);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

