/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.detect;

import java.util.Locale;
import org.apache.tika.language.detect.LanguageConfidence;

public class LanguageResult {
    public static final LanguageResult NULL = new LanguageResult("", LanguageConfidence.NONE, 0.0f);
    private String language;
    private LanguageConfidence confidence;
    private float rawScore;

    public LanguageResult(String string, LanguageConfidence languageConfidence, float f) {
        this.language = string;
        this.confidence = languageConfidence;
        this.rawScore = f;
    }

    public String getLanguage() {
        return this.language;
    }

    public float getRawScore() {
        return this.rawScore;
    }

    public LanguageConfidence getConfidence() {
        return this.confidence;
    }

    public boolean isReasonablyCertain() {
        return this.confidence == LanguageConfidence.HIGH;
    }

    public boolean isUnknown() {
        return this.confidence == LanguageConfidence.NONE;
    }

    public boolean isLanguage(String string) {
        String[] stringArray = string.split("\\-");
        String[] stringArray2 = this.language.split("\\-");
        int n = Math.min(stringArray.length, stringArray2.length);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equalsIgnoreCase(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format(Locale.US, "%s: %s (%f)", new Object[]{this.language, this.confidence, Float.valueOf(this.rawScore)});
    }
}

