/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.translate.Translator;

public class DefaultTranslator
implements Translator {
    private final transient ServiceLoader loader;

    public DefaultTranslator(ServiceLoader serviceLoader) {
        this.loader = serviceLoader;
    }

    public DefaultTranslator() {
        this(new ServiceLoader());
    }

    private static List<Translator> getDefaultTranslators(ServiceLoader serviceLoader) {
        List<Translator> list = serviceLoader.loadStaticServiceProviders(Translator.class);
        Collections.sort(list, new Comparator<Translator>(){

            @Override
            public int compare(Translator translator, Translator translator2) {
                boolean bl;
                String string = translator.getClass().getName();
                String string2 = translator2.getClass().getName();
                boolean bl2 = string.startsWith("org.apache.tika.");
                if (bl2 == (bl = string2.startsWith("org.apache.tika."))) {
                    return string.compareTo(string2);
                }
                if (bl2) {
                    return -1;
                }
                return 1;
            }
        });
        return list;
    }

    private static Translator getFirstAvailable(ServiceLoader serviceLoader) {
        for (Translator translator : DefaultTranslator.getDefaultTranslators(serviceLoader)) {
            if (!translator.isAvailable()) continue;
            return translator;
        }
        return null;
    }

    @Override
    public String translate(String string, String string2, String string3) throws TikaException, IOException {
        Translator translator = DefaultTranslator.getFirstAvailable(this.loader);
        if (translator != null) {
            return translator.translate(string, string2, string3);
        }
        throw new TikaException("No translators currently available");
    }

    @Override
    public String translate(String string, String string2) throws TikaException, IOException {
        Translator translator = DefaultTranslator.getFirstAvailable(this.loader);
        if (translator != null) {
            return translator.translate(string, string2);
        }
        throw new TikaException("No translators currently available");
    }

    public List<Translator> getTranslators() {
        return DefaultTranslator.getDefaultTranslators(this.loader);
    }

    public Translator getTranslator() {
        return DefaultTranslator.getFirstAvailable(this.loader);
    }

    @Override
    public boolean isAvailable() {
        return DefaultTranslator.getFirstAvailable(this.loader) != null;
    }
}

