/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

public class HexCoDec {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] decode(String string) {
        return HexCoDec.decode(string.toCharArray());
    }

    public static byte[] decode(char[] cArray) {
        return HexCoDec.decode(cArray, 0, cArray.length);
    }

    public static byte[] decode(char[] cArray, int n, int n2) {
        if ((n2 & 1) != 0) {
            throw new IllegalArgumentException("Length must be even");
        }
        byte[] byArray = new byte[n2 / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(HexCoDec.hexCharToNibble(cArray[n++]) * 16 + HexCoDec.hexCharToNibble(cArray[n++]));
        }
        return byArray;
    }

    public static char[] encode(byte[] byArray) {
        return HexCoDec.encode(byArray, 0, byArray.length);
    }

    public static char[] encode(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = byArray[n++] & 0xFF;
            cArray[n3++] = HEX_CHARS[n4 >> 4];
            cArray[n3++] = HEX_CHARS[n4 & 0xF];
        }
        return cArray;
    }

    private static int hexCharToNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Not a hex char - '" + c + "'");
    }
}

