/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import org.apache.tika.mime.Clause;
import org.apache.tika.mime.MimeType;

class Magic
implements Clause,
Comparable<Magic> {
    private final MimeType type;
    private final int priority;
    private final Clause clause;
    private final String string;

    Magic(MimeType mimeType, int n, Clause clause) {
        this.type = mimeType;
        this.priority = n;
        this.clause = clause;
        this.string = "[" + n + "/" + String.valueOf(clause) + "]";
    }

    MimeType getType() {
        return this.type;
    }

    int getPriority() {
        return this.priority;
    }

    @Override
    public boolean eval(byte[] byArray) {
        return this.clause.eval(byArray);
    }

    @Override
    public int size() {
        return this.clause.size();
    }

    public String toString() {
        return this.string;
    }

    @Override
    public int compareTo(Magic magic) {
        int n = magic.priority - this.priority;
        if (n == 0) {
            n = magic.size() - this.size();
        }
        if (n == 0) {
            n = magic.type.compareTo(this.type);
        }
        if (n == 0) {
            n = magic.string.compareTo(this.string);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof Magic) {
            Magic magic = (Magic)object;
            return this.type.equals(magic.type) && this.string.equals(magic.string);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.string.hashCode();
    }
}

