/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.tika.detect.MagicDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.Clause;
import org.apache.tika.mime.MediaType;

class MagicMatch
implements Clause {
    private final MediaType mediaType;
    private final String type;
    private final String offset;
    private final String value;
    private final String mask;
    private MagicDetector detector = null;

    MagicMatch(MediaType mediaType, String string, String string2, String string3, String string4) {
        this.mediaType = mediaType;
        this.type = string;
        this.offset = string2;
        this.value = string3;
        this.mask = string4;
    }

    private synchronized MagicDetector getDetector() {
        if (this.detector == null) {
            this.detector = MagicDetector.parse(this.mediaType, this.type, this.offset, this.value, this.mask);
        }
        return this.detector;
    }

    @Override
    public boolean eval(byte[] byArray) {
        try {
            return this.getDetector().detect(new ByteArrayInputStream(byArray), new Metadata()) != MediaType.OCTET_STREAM;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public int size() {
        return this.getDetector().getLength();
    }

    public String toString() {
        return this.mediaType.toString() + " " + this.type + " " + this.offset + " " + this.value + " " + this.mask;
    }
}

