/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MediaType
implements Comparable<MediaType>,
Serializable {
    private static final long serialVersionUID = -3831000556189036392L;
    private static final Pattern SPECIAL = Pattern.compile("[\\(\\)<>@,;:\\\\\"/\\[\\]\\?=]");
    private static final Pattern SPECIAL_OR_WHITESPACE = Pattern.compile("[\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]");
    private static final String VALID_CHARS = "([^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]+)";
    private static final Pattern TYPE_PATTERN = Pattern.compile("(?s)\\s*([^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]+)\\s*/\\s*([^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]+)\\s*($|;.*)");
    private static final Pattern CHARSET_FIRST_PATTERN = Pattern.compile("(?is)\\s*(charset\\s*=\\s*[^\\c;\\s]+)\\s*;\\s*([^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]+)\\s*/\\s*([^\\c\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]+)\\s*");
    private static final Map<String, MediaType> SIMPLE_TYPES = new HashMap<String, MediaType>();
    public static final MediaType OCTET_STREAM = MediaType.parse("application/octet-stream");
    public static final MediaType EMPTY = MediaType.parse("application/x-empty");
    public static final MediaType TEXT_PLAIN = MediaType.parse("text/plain");
    public static final MediaType TEXT_HTML = MediaType.parse("text/html");
    public static final MediaType APPLICATION_XML = MediaType.parse("application/xml");
    public static final MediaType APPLICATION_ZIP = MediaType.parse("application/zip");
    private final String string;
    private final int slash;
    private final int semicolon;
    private final Map<String, String> parameters;

    public static MediaType application(String string) {
        return MediaType.parse("application/" + string);
    }

    public static MediaType audio(String string) {
        return MediaType.parse("audio/" + string);
    }

    public static MediaType image(String string) {
        return MediaType.parse("image/" + string);
    }

    public static MediaType text(String string) {
        return MediaType.parse("text/" + string);
    }

    public static MediaType video(String string) {
        return MediaType.parse("video/" + string);
    }

    public static Set<MediaType> set(MediaType ... mediaTypeArray) {
        HashSet<MediaType> hashSet = new HashSet<MediaType>();
        for (MediaType mediaType : mediaTypeArray) {
            if (mediaType == null) continue;
            hashSet.add(mediaType);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static Set<MediaType> set(String ... stringArray) {
        HashSet<MediaType> hashSet = new HashSet<MediaType>();
        for (String string : stringArray) {
            MediaType mediaType = MediaType.parse(string);
            if (mediaType == null) continue;
            hashSet.add(mediaType);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaType parse(String string) {
        if (string == null) {
            return null;
        }
        Object object = SIMPLE_TYPES;
        synchronized (object) {
            MediaType mediaType = SIMPLE_TYPES.get(string);
            if (mediaType == null) {
                int n = string.indexOf(47);
                if (n == -1) {
                    return null;
                }
                if (SIMPLE_TYPES.size() < 10000 && MediaType.isSimpleName(string.substring(0, n)) && MediaType.isSimpleName(string.substring(n + 1))) {
                    mediaType = new MediaType(string, n);
                    SIMPLE_TYPES.put(string, mediaType);
                }
            }
            if (mediaType != null) {
                return mediaType;
            }
        }
        object = TYPE_PATTERN.matcher(string);
        if (((Matcher)object).matches()) {
            return new MediaType(((Matcher)object).group(1), ((Matcher)object).group(2), MediaType.parseParameters(((Matcher)object).group(3)));
        }
        object = CHARSET_FIRST_PATTERN.matcher(string);
        if (((Matcher)object).matches()) {
            return new MediaType(((Matcher)object).group(2), ((Matcher)object).group(3), MediaType.parseParameters(((Matcher)object).group(1)));
        }
        return null;
    }

    private static boolean isSimpleName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '-' || c == '+' || c == '.' || c == '_' || '0' <= c && c <= '9' || 'a' <= c && c <= 'z') continue;
            return false;
        }
        return string.length() > 0;
    }

    private static Map<String, String> parseParameters(String string) {
        if (string.length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (string.length() > 0) {
            String string2 = string;
            String string3 = "";
            int n = string.indexOf(59);
            if (n != -1) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                string = "";
            }
            int n2 = string2.indexOf(61);
            if (n2 != -1) {
                string3 = string2.substring(n2 + 1);
                string2 = string2.substring(0, n2);
            }
            if ((string2 = string2.trim()).length() <= 0) continue;
            hashMap.put(string2, MediaType.unquote(string3.trim()));
        }
        return hashMap;
    }

    private static String unquote(String string) {
        while (string.startsWith("\"") || string.startsWith("'")) {
            string = string.substring(1);
        }
        while (string.endsWith("\"") || string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public MediaType(String string, String string2, Map<String, String> map) {
        string = string.trim().toLowerCase(Locale.ENGLISH);
        string2 = string2.trim().toLowerCase(Locale.ENGLISH);
        this.slash = string.length();
        this.semicolon = this.slash + 1 + string2.length();
        if (map.isEmpty()) {
            this.parameters = Collections.emptyMap();
            this.string = string + "/" + string2;
        } else {
            String string3;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append('/');
            stringBuilder.append(string2);
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                string3 = entry.getKey().trim().toLowerCase(Locale.ENGLISH);
                treeMap.put(string3, entry.getValue());
            }
            for (Map.Entry<String, String> entry : treeMap.entrySet()) {
                stringBuilder.append("; ");
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                string3 = entry.getValue();
                if (SPECIAL_OR_WHITESPACE.matcher(string3).find()) {
                    stringBuilder.append('\"');
                    stringBuilder.append(SPECIAL.matcher(string3).replaceAll("\\\\$0"));
                    stringBuilder.append('\"');
                    continue;
                }
                stringBuilder.append(string3);
            }
            this.string = stringBuilder.toString();
            this.parameters = Collections.unmodifiableSortedMap(treeMap);
        }
    }

    public MediaType(String string, String string2) {
        this(string, string2, Collections.emptyMap());
    }

    private MediaType(String string, int n) {
        assert (n != -1);
        assert (string.charAt(n) == '/');
        assert (MediaType.isSimpleName(string.substring(0, n)));
        assert (MediaType.isSimpleName(string.substring(n + 1)));
        this.string = string;
        this.slash = n;
        this.semicolon = string.length();
        this.parameters = Collections.emptyMap();
    }

    private static Map<String, String> union(Map<String, String> map, Map<String, String> map2) {
        if (map.isEmpty()) {
            return map2;
        }
        if (map2.isEmpty()) {
            return map;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(map);
        hashMap.putAll(map2);
        return hashMap;
    }

    public MediaType(MediaType mediaType, Map<String, String> map) {
        this(mediaType.getType(), mediaType.getSubtype(), MediaType.union(mediaType.parameters, map));
    }

    public MediaType(MediaType mediaType, String string, String string2) {
        this(mediaType, Collections.singletonMap(string, string2));
    }

    public MediaType(MediaType mediaType, Charset charset) {
        this(mediaType, "charset", charset.name());
    }

    public MediaType getBaseType() {
        if (this.parameters.isEmpty()) {
            return this;
        }
        return MediaType.parse(this.string.substring(0, this.semicolon));
    }

    public String getType() {
        return this.string.substring(0, this.slash);
    }

    public String getSubtype() {
        return this.string.substring(this.slash + 1, this.semicolon);
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.string;
    }

    public boolean equals(Object object) {
        if (object instanceof MediaType) {
            MediaType mediaType = (MediaType)object;
            return this.string.equals(mediaType.string);
        }
        return false;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public int compareTo(MediaType mediaType) {
        return this.string.compareTo(mediaType.string);
    }
}

