/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;

public class MediaTypeRegistry
implements Serializable {
    private static final long serialVersionUID = 4710974869988895410L;
    private final Map<MediaType, MediaType> registry = new HashMap<MediaType, MediaType>();
    private final Map<MediaType, MediaType> inheritance = new HashMap<MediaType, MediaType>();

    public static MediaTypeRegistry getDefaultRegistry() {
        return MimeTypes.getDefaultMimeTypes().getMediaTypeRegistry();
    }

    public SortedSet<MediaType> getTypes() {
        return new TreeSet<MediaType>(this.registry.values());
    }

    public SortedSet<MediaType> getAliases(MediaType mediaType) {
        TreeSet<MediaType> treeSet = new TreeSet<MediaType>();
        for (Map.Entry<MediaType, MediaType> entry : this.registry.entrySet()) {
            if (!entry.getValue().equals(mediaType) || entry.getKey().equals(mediaType)) continue;
            treeSet.add(entry.getKey());
        }
        return treeSet;
    }

    public SortedSet<MediaType> getChildTypes(MediaType mediaType) {
        TreeSet<MediaType> treeSet = new TreeSet<MediaType>();
        for (Map.Entry<MediaType, MediaType> entry : this.inheritance.entrySet()) {
            if (!entry.getValue().equals(mediaType)) continue;
            treeSet.add(entry.getKey());
        }
        return treeSet;
    }

    public void addType(MediaType mediaType) {
        this.registry.put(mediaType, mediaType);
    }

    public void addAlias(MediaType mediaType, MediaType mediaType2) {
        this.registry.put(mediaType2, mediaType);
    }

    public void addSuperType(MediaType mediaType, MediaType mediaType2) {
        this.inheritance.put(mediaType, mediaType2);
    }

    public MediaType normalize(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        MediaType mediaType2 = this.registry.get(mediaType.getBaseType());
        if (mediaType2 == null) {
            return mediaType;
        }
        if (mediaType.hasParameters()) {
            return new MediaType(mediaType2, mediaType.getParameters());
        }
        return mediaType2;
    }

    public boolean isSpecializationOf(MediaType mediaType, MediaType mediaType2) {
        return this.isInstanceOf(this.getSupertype(mediaType), mediaType2);
    }

    public boolean isInstanceOf(MediaType mediaType, MediaType mediaType2) {
        return mediaType != null && (mediaType.equals(mediaType2) || this.isSpecializationOf(mediaType, mediaType2));
    }

    public boolean isInstanceOf(String string, MediaType mediaType) {
        return this.isInstanceOf(this.normalize(MediaType.parse(string)), mediaType);
    }

    public MediaType getSupertype(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        if (this.inheritance.containsKey(mediaType)) {
            return this.inheritance.get(mediaType);
        }
        if (mediaType.hasParameters()) {
            return mediaType.getBaseType();
        }
        if (mediaType.getSubtype().endsWith("+xml")) {
            return MediaType.APPLICATION_XML;
        }
        if (mediaType.getSubtype().endsWith("+zip")) {
            return MediaType.APPLICATION_ZIP;
        }
        if ("text".equals(mediaType.getType()) && !MediaType.TEXT_PLAIN.equals(mediaType)) {
            return MediaType.TEXT_PLAIN;
        }
        if (mediaType.getType().contains("empty") && !MediaType.EMPTY.equals(mediaType)) {
            return MediaType.EMPTY;
        }
        if (!MediaType.OCTET_STREAM.equals(mediaType)) {
            return MediaType.OCTET_STREAM;
        }
        return null;
    }
}

