/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MediaType;

public final class MimeType
implements Comparable<MimeType>,
Serializable {
    private static final long serialVersionUID = 4357830439860729201L;
    private final MediaType type;
    private String acronym = "";
    private String uti = "";
    private List<URI> links = Collections.emptyList();
    private String description = "";
    private List<Magic> magics = null;
    private List<RootXML> rootXML = null;
    private int minLength = 0;
    private List<String> extensions = null;

    public static boolean isValid(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name is missing");
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= ' ' || c >= '\u007f' || c == '(' || c == ')' || c == '<' || c == '>' || c == '@' || c == ',' || c == ';' || c == ':' || c == '\\' || c == '\"' || c == '[' || c == ']' || c == '?' || c == '=') {
                return false;
            }
            if (c != '/') continue;
            if (bl || i == 0 || i + 1 == string.length()) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    MimeType(MediaType mediaType) {
        if (mediaType == null) {
            throw new IllegalArgumentException("Media type name is missing");
        }
        this.type = mediaType;
    }

    public MediaType getType() {
        return this.type;
    }

    public String getName() {
        return this.type.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Description is missing");
        }
        this.description = string;
    }

    public String getAcronym() {
        return this.acronym;
    }

    void setAcronym(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Acronym is missing");
        }
        this.acronym = string;
    }

    public String getUniformTypeIdentifier() {
        return this.uti;
    }

    void setUniformTypeIdentifier(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Uniform Type Identifier is missing");
        }
        this.uti = string;
    }

    public List<URI> getLinks() {
        return this.links;
    }

    void addLink(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("Missing Link");
        }
        ArrayList<URI> arrayList = new ArrayList<URI>(this.links.size() + 1);
        arrayList.addAll(this.links);
        arrayList.add(uRI);
        this.links = Collections.unmodifiableList(arrayList);
    }

    void addRootXML(String string, String string2) {
        if (this.rootXML == null) {
            this.rootXML = new ArrayList<RootXML>();
        }
        this.rootXML.add(new RootXML(this, string, string2));
    }

    boolean matchesXML(String string, String string2) {
        if (this.rootXML != null) {
            for (RootXML rootXML : this.rootXML) {
                if (!rootXML.matches(string, string2)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasRootXML() {
        return this.rootXML != null;
    }

    List<Magic> getMagics() {
        if (this.magics != null) {
            return this.magics;
        }
        return Collections.emptyList();
    }

    void addMagic(Magic magic) {
        if (magic == null) {
            return;
        }
        if (this.magics == null) {
            this.magics = new ArrayList<Magic>();
        }
        this.magics.add(magic);
    }

    int getMinLength() {
        return this.minLength;
    }

    public boolean hasMagic() {
        return this.magics != null;
    }

    public boolean matchesMagic(byte[] byArray) {
        for (int i = 0; this.magics != null && i < this.magics.size(); ++i) {
            Magic magic = this.magics.get(i);
            if (!magic.eval(byArray)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(byte[] byArray) {
        return this.matchesMagic(byArray);
    }

    @Override
    public int compareTo(MimeType mimeType) {
        return this.type.compareTo(mimeType.type);
    }

    public boolean equals(Object object) {
        if (object instanceof MimeType) {
            MimeType mimeType = (MimeType)object;
            return this.type.equals(mimeType.type);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return this.type.toString();
    }

    public String getExtension() {
        if (this.extensions == null) {
            return "";
        }
        return this.extensions.get(0);
    }

    public List<String> getExtensions() {
        if (this.extensions != null) {
            return Collections.unmodifiableList(this.extensions);
        }
        return Collections.emptyList();
    }

    void addExtension(String string) {
        if (this.extensions == null) {
            this.extensions = Collections.singletonList(string);
        } else if (this.extensions.size() == 1) {
            this.extensions = new ArrayList<String>(this.extensions);
        }
        if (!this.extensions.contains(string)) {
            this.extensions.add(string);
        }
    }

    static class RootXML
    implements Serializable {
        private static final long serialVersionUID = 5140496601491000730L;
        private MimeType type = null;
        private String namespaceURI = null;
        private String localName = null;

        RootXML(MimeType mimeType, String string, String string2) {
            if (this.isEmpty(string) && this.isEmpty(string2)) {
                throw new IllegalArgumentException("Both namespaceURI and localName cannot be empty");
            }
            this.type = mimeType;
            this.namespaceURI = string;
            this.localName = string2;
        }

        boolean matches(String string, String string2) {
            if (!this.isEmpty(this.namespaceURI) ? !this.namespaceURI.equals(string) : !this.isEmpty(string)) {
                return false;
            }
            return !(!this.isEmpty(this.localName) ? !this.localName.equals(string2) : !this.isEmpty(string2));
        }

        private boolean isEmpty(String string) {
            return string == null || string.equals("");
        }

        MimeType getType() {
            return this.type;
        }

        String getNameSpaceURI() {
            return this.namespaceURI;
        }

        String getLocalName() {
            return this.localName;
        }

        public String toString() {
            return String.valueOf(this.type) + ", " + this.namespaceURI + ", " + this.localName;
        }
    }
}

