/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReader;
import org.w3c.dom.Document;

public class MimeTypesFactory {
    public static MimeTypes create() {
        return new MimeTypes();
    }

    public static MimeTypes create(Document document) throws MimeTypeException {
        MimeTypes mimeTypes = new MimeTypes();
        new MimeTypesReader(mimeTypes).read(document);
        mimeTypes.init();
        return mimeTypes;
    }

    public static MimeTypes create(InputStream ... inputStreamArray) throws IOException, MimeTypeException {
        MimeTypes mimeTypes = new MimeTypes();
        MimeTypesReader mimeTypesReader = new MimeTypesReader(mimeTypes);
        for (InputStream inputStream : inputStreamArray) {
            mimeTypesReader.read(inputStream);
        }
        mimeTypes.init();
        return mimeTypes;
    }

    public static MimeTypes create(InputStream inputStream) throws IOException, MimeTypeException {
        return MimeTypesFactory.create(new InputStream[]{inputStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeTypes create(URL ... uRLArray) throws IOException, MimeTypeException {
        InputStream[] inputStreamArray = new InputStream[uRLArray.length];
        for (int i = 0; i < inputStreamArray.length; ++i) {
            inputStreamArray[i] = uRLArray[i].openStream();
        }
        try {
            MimeTypes mimeTypes = MimeTypesFactory.create(inputStreamArray);
            return mimeTypes;
        }
        finally {
            for (InputStream inputStream : inputStreamArray) {
                inputStream.close();
            }
        }
    }

    public static MimeTypes create(URL uRL) throws IOException, MimeTypeException {
        return MimeTypesFactory.create(new URL[]{uRL});
    }

    public static MimeTypes create(String string) throws IOException, MimeTypeException {
        return MimeTypesFactory.create(MimeTypesReader.class.getResource(string));
    }

    public static MimeTypes create(String string, String string2) throws IOException, MimeTypeException {
        return MimeTypesFactory.create(string, string2, null);
    }

    public static MimeTypes create(String string, String string2, ClassLoader classLoader) throws IOException, MimeTypeException {
        if (classLoader == null) {
            classLoader = MimeTypesReader.class.getClassLoader();
        }
        String string3 = MimeTypesReader.class.getPackage().getName().replace('.', '/') + "/";
        URL uRL = classLoader.getResource(string3 + string);
        ArrayList<URL> arrayList = Collections.list(classLoader.getResources(string3 + string2));
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        arrayList2.add(uRL);
        arrayList2.addAll(arrayList);
        return MimeTypesFactory.create(arrayList2.toArray(new URL[arrayList2.size()]));
    }
}

