/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;

class Patterns
implements Serializable {
    private static final long serialVersionUID = -5778015347278111140L;
    private final MediaTypeRegistry registry;
    private final Map<String, MimeType> names = new HashMap<String, MimeType>();
    private final Map<String, MimeType> extensions = new HashMap<String, MimeType>();
    private int minExtensionLength = Integer.MAX_VALUE;
    private int maxExtensionLength = 0;
    private final SortedMap<String, MimeType> globs = new TreeMap<String, MimeType>(new LengthComparator());

    public Patterns(MediaTypeRegistry mediaTypeRegistry) {
        this.registry = mediaTypeRegistry;
    }

    public void add(String string, MimeType mimeType) throws MimeTypeException {
        this.add(string, false, mimeType);
    }

    public void add(String string, boolean bl, MimeType mimeType) throws MimeTypeException {
        if (string == null || mimeType == null) {
            throw new IllegalArgumentException("Pattern and/or mime type is missing");
        }
        if (bl) {
            this.addGlob(string, mimeType);
        } else if (string.indexOf(42) == -1 && string.indexOf(63) == -1 && string.indexOf(91) == -1) {
            this.addName(string, mimeType);
        } else if (string.startsWith("*") && string.indexOf(42, 1) == -1 && string.indexOf(63) == -1 && string.indexOf(91) == -1) {
            String string2 = string.substring(1);
            this.addExtension(string2, mimeType);
            mimeType.addExtension(string2);
        } else {
            this.addGlob(this.compile(string), mimeType);
        }
    }

    private void addName(String string, MimeType mimeType) throws MimeTypeException {
        MimeType mimeType2 = this.names.get(string);
        if (mimeType2 == null || this.registry.isSpecializationOf(mimeType2.getType(), mimeType.getType())) {
            this.names.put(string, mimeType);
        } else if (mimeType2 != mimeType && !this.registry.isSpecializationOf(mimeType.getType(), mimeType2.getType())) {
            throw new MimeTypeException("Conflicting name pattern: " + string);
        }
    }

    private void addExtension(String string, MimeType mimeType) throws MimeTypeException {
        MimeType mimeType2 = this.extensions.get(string);
        if (mimeType2 == null || this.registry.isSpecializationOf(mimeType2.getType(), mimeType.getType())) {
            this.extensions.put(string, mimeType);
            int n = string.length();
            this.minExtensionLength = Math.min(this.minExtensionLength, n);
            this.maxExtensionLength = Math.max(this.maxExtensionLength, n);
        } else if (mimeType2 != mimeType && !this.registry.isSpecializationOf(mimeType.getType(), mimeType2.getType())) {
            throw new MimeTypeException("Conflicting extension pattern: " + string);
        }
    }

    private void addGlob(String string, MimeType mimeType) throws MimeTypeException {
        MimeType mimeType2 = (MimeType)this.globs.get(string);
        if (mimeType2 == null || this.registry.isSpecializationOf(mimeType2.getType(), mimeType.getType())) {
            this.globs.put(string, mimeType);
        } else if (mimeType2 != mimeType && !this.registry.isSpecializationOf(mimeType.getType(), mimeType2.getType())) {
            throw new MimeTypeException("Conflicting glob pattern: " + string);
        }
    }

    public MimeType matches(String string) {
        int n;
        if (string == null) {
            throw new IllegalArgumentException("Name is missing");
        }
        if (this.names.containsKey(string)) {
            return this.names.get(string);
        }
        for (int i = n = Math.min(this.maxExtensionLength, string.length()); i >= this.minExtensionLength; --i) {
            Map.Entry<String, MimeType> entry = string.substring(string.length() - i);
            if (!this.extensions.containsKey(entry)) continue;
            return this.extensions.get(entry);
        }
        for (Map.Entry<String, MimeType> entry : this.globs.entrySet()) {
            if (!string.matches((String)entry.getKey())) continue;
            return (MimeType)entry.getValue();
        }
        return null;
    }

    private String compile(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\\A");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '?') {
                stringBuilder.append('.');
                continue;
            }
            if (c == '*') {
                stringBuilder.append(".*");
                continue;
            }
            if ("\\[]^.-$+(){}|".indexOf(c) != -1) {
                stringBuilder.append('\\');
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append("\\z");
        return stringBuilder.toString();
    }

    private static final class LengthComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8468289702915532359L;

        private LengthComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = string2.length() - string.length();
            if (n == 0) {
                n = string.compareTo(string2);
            }
            return n;
        }
    }
}

