/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.SecureContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AutoDetectParser
extends CompositeParser {
    private static final long serialVersionUID = 6110455808615143122L;
    private Detector detector;

    public AutoDetectParser() {
        this(TikaConfig.getDefaultConfig());
    }

    public AutoDetectParser(Detector detector) {
        this(TikaConfig.getDefaultConfig());
        this.setDetector(detector);
    }

    public AutoDetectParser(Parser ... parserArray) {
        this(new DefaultDetector(), parserArray);
    }

    public AutoDetectParser(Detector detector, Parser ... parserArray) {
        super(MediaTypeRegistry.getDefaultRegistry(), parserArray);
        this.setDetector(detector);
    }

    public AutoDetectParser(TikaConfig tikaConfig) {
        super(tikaConfig.getMediaTypeRegistry(), tikaConfig.getParser());
        this.setDetector(tikaConfig.getDetector());
    }

    public Detector getDetector() {
        return this.detector;
    }

    public void setDetector(Detector detector) {
        this.detector = detector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        TemporaryResources temporaryResources = new TemporaryResources();
        try {
            TikaInputStream tikaInputStream = TikaInputStream.get(inputStream, temporaryResources);
            MediaType mediaType = this.detector.detect(tikaInputStream, metadata);
            metadata.set("Content-Type", mediaType.toString());
            SecureContentHandler secureContentHandler = contentHandler != null ? new SecureContentHandler(contentHandler, tikaInputStream) : null;
            try {
                super.parse(tikaInputStream, secureContentHandler, metadata, parseContext);
            }
            catch (SAXException sAXException) {
                secureContentHandler.throwIfCauseOf(sAXException);
                throw sAXException;
            }
        }
        finally {
            temporaryResources.dispose();
        }
    }

    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata) throws IOException, SAXException, TikaException {
        ParseContext parseContext = new ParseContext();
        parseContext.set(Parser.class, this);
        this.parse(inputStream, contentHandler, metadata, parseContext);
    }
}

