/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.TaggedContentHandler;
import org.apache.tika.sax.TeeContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NetworkParser
extends AbstractParser {
    private final URI uri;
    private final Set<MediaType> supportedTypes;

    public NetworkParser(URI uRI, Set<MediaType> set) {
        this.uri = uRI;
        this.supportedTypes = set;
    }

    public NetworkParser(URI uRI) {
        this(uRI, Collections.singleton(MediaType.OCTET_STREAM));
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return this.supportedTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        TemporaryResources temporaryResources = new TemporaryResources();
        try {
            TikaInputStream tikaInputStream = TikaInputStream.get(inputStream, temporaryResources);
            this.parse(tikaInputStream, contentHandler, metadata, parseContext);
        }
        finally {
            temporaryResources.dispose();
        }
    }

    private void parse(TikaInputStream tikaInputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        if ("telnet".equals(this.uri.getScheme())) {
            try (final Socket socket = new Socket(this.uri.getHost(), this.uri.getPort());){
                new ParsingTask(tikaInputStream, new FilterOutputStream(this, socket.getOutputStream()){

                    @Override
                    public void close() throws IOException {
                        socket.shutdownOutput();
                    }
                }).parse(socket.getInputStream(), contentHandler, metadata, parseContext);
            }
        }
        URL uRL = this.uri.toURL();
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        uRLConnection.connect();
        try (InputStream inputStream = uRLConnection.getInputStream();){
            new ParsingTask(tikaInputStream, uRLConnection.getOutputStream()).parse(new CloseShieldInputStream(inputStream), contentHandler, metadata, parseContext);
        }
    }

    private static class ParsingTask
    implements Runnable {
        private final TikaInputStream input;
        private final OutputStream output;
        private volatile Exception exception = null;

        public ParsingTask(TikaInputStream tikaInputStream, OutputStream outputStream) {
            this.input = tikaInputStream;
            this.output = outputStream;
        }

        public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
            Thread thread = new Thread((Runnable)this, "Tika network parser");
            thread.start();
            TaggedContentHandler taggedContentHandler = new TaggedContentHandler(new OfflineContentHandler(contentHandler));
            try {
                parseContext.getSAXParser().parse(inputStream, (DefaultHandler)new TeeContentHandler(taggedContentHandler, new MetaHandler(metadata)));
            }
            catch (SAXException sAXException) {
                taggedContentHandler.throwIfCauseOf(sAXException);
                throw new TikaException("Invalid network parser output", sAXException);
            }
            catch (IOException iOException) {
                throw new TikaException("Unable to read network parser output", iOException);
            }
            finally {
                try {
                    thread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new TikaException("Network parser interrupted", interruptedException);
                }
                if (this.exception != null) {
                    this.input.throwIfCauseOf(this.exception);
                    throw new TikaException("Unexpected network parser error", this.exception);
                }
            }
        }

        @Override
        public void run() {
            try {
                try {
                    IOUtils.copy((InputStream)this.input, this.output);
                }
                finally {
                    this.output.close();
                }
            }
            catch (Exception exception) {
                this.exception = exception;
            }
        }
    }

    private static class MetaHandler
    extends DefaultHandler {
        private final Metadata metadata;

        public MetaHandler(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("http://www.w3.org/1999/xhtml".equals(string) && "meta".equals(string2)) {
                String string4 = attributes.getValue("", "name");
                String string5 = attributes.getValue("", "content");
                if (string4 != null && string5 != null) {
                    this.metadata.add(string4, string5);
                }
            }
        }
    }
}

