/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.apache.tika.exception.TikaException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class ParseContext
implements Serializable {
    private static final long serialVersionUID = -5921436862145826534L;
    private final Map<String, Object> context = new HashMap<String, Object>();
    private static final EntityResolver IGNORING_SAX_ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    };
    private static final XMLResolver IGNORING_STAX_ENTITY_RESOLVER = new XMLResolver(){

        @Override
        public Object resolveEntity(String string, String string2, String string3, String string4) throws XMLStreamException {
            return "";
        }
    };

    public <T> void set(Class<T> clazz, T t) {
        if (t != null) {
            this.context.put(clazz.getName(), t);
        } else {
            this.context.remove(clazz.getName());
        }
    }

    public <T> T get(Class<T> clazz) {
        return (T)this.context.get(clazz.getName());
    }

    public <T> T get(Class<T> clazz, T t) {
        T t2 = this.get(clazz);
        if (t2 != null) {
            return t2;
        }
        return t;
    }

    public XMLReader getXMLReader() throws TikaException {
        XMLReader xMLReader = this.get(XMLReader.class);
        if (xMLReader != null) {
            return xMLReader;
        }
        try {
            xMLReader = this.getSAXParser().getXMLReader();
        }
        catch (SAXException sAXException) {
            throw new TikaException("Unable to create an XMLReader", sAXException);
        }
        xMLReader.setEntityResolver(IGNORING_SAX_ENTITY_RESOLVER);
        return xMLReader;
    }

    public SAXParser getSAXParser() throws TikaException {
        SAXParser sAXParser = this.get(SAXParser.class);
        if (sAXParser != null) {
            return sAXParser;
        }
        try {
            return this.getSAXParserFactory().newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TikaException("Unable to configure a SAX parser", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new TikaException("Unable to create a SAX parser", sAXException);
        }
    }

    public SAXParserFactory getSAXParserFactory() {
        SAXParserFactory sAXParserFactory = this.get(SAXParserFactory.class);
        if (sAXParserFactory == null) {
            sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            try {
                sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
        return sAXParserFactory;
    }

    private DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = this.get(DocumentBuilderFactory.class);
        if (documentBuilderFactory != null) {
            return documentBuilderFactory;
        }
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        ParseContext.tryToSetSAXFeatureOnDOMFactory(documentBuilderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        ParseContext.tryToSetXercesManager(documentBuilderFactory);
        return documentBuilderFactory;
    }

    public DocumentBuilder getDocumentBuilder() throws TikaException {
        DocumentBuilder documentBuilder = this.get(DocumentBuilder.class);
        if (documentBuilder != null) {
            return documentBuilder;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = this.getDocumentBuilderFactory();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(IGNORING_SAX_ENTITY_RESOLVER);
            documentBuilder.setErrorHandler(null);
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TikaException("XML parser not available", parserConfigurationException);
        }
    }

    public XMLInputFactory getXMLInputFactory() {
        XMLInputFactory xMLInputFactory = this.get(XMLInputFactory.class);
        if (xMLInputFactory != null) {
            return xMLInputFactory;
        }
        xMLInputFactory = XMLInputFactory.newFactory();
        this.tryToSetStaxProperty(xMLInputFactory, "javax.xml.stream.isNamespaceAware", true);
        this.tryToSetStaxProperty(xMLInputFactory, "javax.xml.stream.isValidating", false);
        xMLInputFactory.setXMLResolver(IGNORING_STAX_ENTITY_RESOLVER);
        return xMLInputFactory;
    }

    private static void tryToSetSAXFeatureOnDOMFactory(DocumentBuilderFactory documentBuilderFactory, String string, boolean bl) {
        try {
            documentBuilderFactory.setFeature(string, bl);
        }
        catch (AbstractMethodError | Exception throwable) {
            // empty catch block
        }
    }

    private static void tryToSetXercesManager(DocumentBuilderFactory documentBuilderFactory) {
        for (String string : new String[]{"com.sun.org.apache.xerces.internal.util.SecurityManager", "org.apache.xerces.util.SecurityManager"}) {
            try {
                Object obj = Class.forName(string).newInstance();
                Method method = obj.getClass().getMethod("setEntityExpansionLimit", Integer.TYPE);
                method.invoke(obj, 4096);
                documentBuilderFactory.setAttribute("http://apache.org/xml/properties/security-manager", obj);
                return;
            }
            catch (Throwable throwable) {
            }
        }
    }

    private void tryToSetStaxProperty(XMLInputFactory xMLInputFactory, String string, boolean bl) {
        try {
            xMLInputFactory.setProperty(string, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

