/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.TeeContentHandler;
import org.apache.tika.utils.RegexUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ParserPostProcessor
extends ParserDecorator {
    public ParserPostProcessor(Parser parser) {
        super(parser);
    }

    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        BodyContentHandler bodyContentHandler = new BodyContentHandler();
        TeeContentHandler teeContentHandler = new TeeContentHandler(contentHandler, bodyContentHandler);
        super.parse(inputStream, teeContentHandler, metadata, parseContext);
        String string = ((Object)bodyContentHandler).toString();
        metadata.set("fulltext", string);
        int n = Math.min(string.length(), 500);
        metadata.set("summary", string.substring(0, n));
        for (String string2 : RegexUtils.extractLinks(string)) {
            metadata.add("outlinks", string2);
        }
    }
}

