/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;

public class ParsingReader
extends Reader {
    private final Parser parser;
    private final Reader reader;
    private final Writer writer;
    private final InputStream stream;
    private final Metadata metadata;
    private final ParseContext context;
    private transient Throwable throwable;

    private static Metadata getMetadata(String string) {
        Metadata metadata = new Metadata();
        if (string != null && string.length() > 0) {
            metadata.set("resourceName", string);
        }
        return metadata;
    }

    public ParsingReader(InputStream inputStream) throws IOException {
        this(new AutoDetectParser(), inputStream, new Metadata(), new ParseContext());
        this.context.set(Parser.class, this.parser);
    }

    public ParsingReader(InputStream inputStream, String string) throws IOException {
        this(new AutoDetectParser(), inputStream, ParsingReader.getMetadata(string), new ParseContext());
        this.context.set(Parser.class, this.parser);
    }

    public ParsingReader(Path path) throws IOException {
        this(Files.newInputStream(path, new OpenOption[0]), path.getFileName().toString());
    }

    public ParsingReader(File file) throws FileNotFoundException, IOException {
        this(new FileInputStream(file), file.getName());
    }

    public ParsingReader(Parser parser, InputStream inputStream, final Metadata metadata, ParseContext parseContext) throws IOException {
        this(parser, inputStream, metadata, parseContext, new Executor(){

            @Override
            public void execute(Runnable runnable) {
                Object object = metadata.get("resourceName");
                object = object != null ? "Apache Tika: " + (String)object : "Apache Tika";
                Thread thread = new Thread(runnable, (String)object);
                thread.setDaemon(true);
                thread.start();
            }
        });
    }

    public ParsingReader(Parser parser, InputStream inputStream, Metadata metadata, ParseContext parseContext, Executor executor) throws IOException {
        this.parser = parser;
        PipedReader pipedReader = new PipedReader();
        this.reader = new BufferedReader(pipedReader);
        try {
            this.writer = new PipedWriter(pipedReader);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        this.stream = inputStream;
        this.metadata = metadata;
        this.context = parseContext;
        executor.execute(new ParsingTask());
        this.reader.mark(1);
        this.reader.read();
        this.reader.reset();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.throwable instanceof IOException) {
            throw (IOException)this.throwable;
        }
        if (this.throwable != null) {
            IOException iOException = new IOException("");
            iOException.initCause(this.throwable);
            throw iOException;
        }
        return this.reader.read(cArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private class ParsingTask
    implements Runnable {
        private ParsingTask() {
        }

        @Override
        public void run() {
            block7: {
                block6: {
                    try {
                        BodyContentHandler bodyContentHandler = new BodyContentHandler(ParsingReader.this.writer);
                        ParsingReader.this.parser.parse(ParsingReader.this.stream, bodyContentHandler, ParsingReader.this.metadata, ParsingReader.this.context);
                    }
                    catch (Throwable throwable) {
                        ParsingReader.this.throwable = throwable;
                    }
                    try {
                        ParsingReader.this.stream.close();
                    }
                    catch (Throwable throwable) {
                        if (ParsingReader.this.throwable != null) break block6;
                        ParsingReader.this.throwable = throwable;
                    }
                }
                try {
                    ParsingReader.this.writer.close();
                }
                catch (Throwable throwable) {
                    if (ParsingReader.this.throwable != null) break block7;
                    ParsingReader.this.throwable = throwable;
                }
            }
        }
    }
}

