/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.FilenameUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.utils.ExceptionUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RecursiveParserWrapper
implements Parser {
    private static final long serialVersionUID = 9086536568120690938L;
    public static final Property TIKA_CONTENT = Property.internalText("X-TIKA:content");
    public static final Property PARSE_TIME_MILLIS = Property.internalText("X-TIKA:parse_time_millis");
    public static final Property WRITE_LIMIT_REACHED = Property.internalBoolean("X-TIKA:EXCEPTION:write_limit_reached");
    public static final Property EMBEDDED_RESOURCE_LIMIT_REACHED = Property.internalBoolean("X-TIKA:EXCEPTION:embedded_resource_limit_reached");
    public static final Property EMBEDDED_EXCEPTION = Property.internalText("X-TIKA:EXCEPTION:embedded_exception");
    public static final Property EMBEDDED_RESOURCE_PATH = Property.internalText("X-TIKA:embedded_resource_path");
    private final Parser wrappedParser;
    private final ContentHandlerFactory contentHandlerFactory;
    private final List<Metadata> metadatas = new LinkedList<Metadata>();
    private final boolean catchEmbeddedExceptions;
    private int unknownCount = 0;
    private int maxEmbeddedResources = -1;
    private boolean hitMaxEmbeddedResources = false;

    public RecursiveParserWrapper(Parser parser, ContentHandlerFactory contentHandlerFactory) {
        this(parser, contentHandlerFactory, true);
    }

    public RecursiveParserWrapper(Parser parser, ContentHandlerFactory contentHandlerFactory, boolean bl) {
        this.wrappedParser = parser;
        this.contentHandlerFactory = contentHandlerFactory;
        this.catchEmbeddedExceptions = bl;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return this.wrappedParser.getSupportedTypes(parseContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        EmbeddedParserDecorator embeddedParserDecorator = new EmbeddedParserDecorator("/");
        parseContext.set(Parser.class, embeddedParserDecorator);
        ContentHandler contentHandler2 = this.contentHandlerFactory.getNewContentHandler();
        long l = new Date().getTime();
        try {
            this.wrappedParser.parse(inputStream, contentHandler2, metadata, parseContext);
        }
        catch (SAXException sAXException) {
            boolean bl = this.isWriteLimitReached(sAXException);
            if (!bl) {
                throw sAXException;
            }
            metadata.set(WRITE_LIMIT_REACHED, "true");
        }
        finally {
            long l2 = new Date().getTime() - l;
            metadata.set(PARSE_TIME_MILLIS, Long.toString(l2));
            this.addContent(contentHandler2, metadata);
            if (this.hitMaxEmbeddedResources) {
                metadata.set(EMBEDDED_RESOURCE_LIMIT_REACHED, "true");
            }
            this.metadatas.add(0, this.deepCopy(metadata));
        }
    }

    public List<Metadata> getMetadata() {
        return this.metadatas;
    }

    public void setMaxEmbeddedResources(int n) {
        this.maxEmbeddedResources = n;
    }

    public void reset() {
        this.metadatas.clear();
        this.unknownCount = 0;
        this.hitMaxEmbeddedResources = false;
    }

    private boolean isWriteLimitReached(Throwable throwable) {
        if (throwable.getMessage() != null && throwable.getMessage().indexOf("Your document contained more than") == 0) {
            return true;
        }
        return throwable.getCause() != null && this.isWriteLimitReached(throwable.getCause());
    }

    private Metadata deepCopy(Metadata metadata) {
        Metadata metadata2 = new Metadata();
        for (String string : metadata.names()) {
            if (!metadata.isMultiValued(string)) {
                metadata2.set(string, metadata.get(string));
                continue;
            }
            String[] stringArray = metadata.getValues(string);
            for (int i = 0; i < stringArray.length; ++i) {
                metadata2.add(string, stringArray[i]);
            }
        }
        return metadata2;
    }

    private String getResourceName(Metadata metadata) {
        Object object = "";
        object = metadata.get("resourceName") != null ? metadata.get("resourceName") : (metadata.get("embeddedRelationshipId") != null ? metadata.get("embeddedRelationshipId") : "embedded-" + ++this.unknownCount);
        object = FilenameUtils.getName((String)object);
        return object;
    }

    private void addContent(ContentHandler contentHandler, Metadata metadata) {
        String string;
        if (!contentHandler.getClass().equals(DefaultHandler.class) && (string = contentHandler.toString()) != null && string.trim().length() > 0) {
            metadata.add(TIKA_CONTENT, string);
        }
    }

    private class EmbeddedParserDecorator
    extends ParserDecorator {
        private static final long serialVersionUID = 207648200464263337L;
        private String location;

        private EmbeddedParserDecorator(String string) {
            super(RecursiveParserWrapper.this.wrappedParser);
            this.location = null;
            this.location = string;
            if (!this.location.endsWith("/")) {
                this.location = this.location + "/";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
            ContentHandler contentHandler2;
            block12: {
                if (RecursiveParserWrapper.this.maxEmbeddedResources > -1 && RecursiveParserWrapper.this.metadatas.size() >= RecursiveParserWrapper.this.maxEmbeddedResources) {
                    RecursiveParserWrapper.this.hitMaxEmbeddedResources = true;
                    return;
                }
                String string = RecursiveParserWrapper.this.getResourceName(metadata);
                String string2 = this.location + string;
                metadata.add(EMBEDDED_RESOURCE_PATH, string2);
                contentHandler2 = RecursiveParserWrapper.this.contentHandlerFactory.getNewContentHandler();
                Parser parser = parseContext.get(Parser.class);
                parseContext.set(Parser.class, new EmbeddedParserDecorator(string2));
                long l = new Date().getTime();
                try {
                    super.parse(inputStream, contentHandler2, metadata, parseContext);
                }
                catch (SAXException sAXException) {
                    boolean bl = RecursiveParserWrapper.this.isWriteLimitReached(sAXException);
                    if (bl) {
                        metadata.add(WRITE_LIMIT_REACHED, "true");
                        break block12;
                    }
                    if (RecursiveParserWrapper.this.catchEmbeddedExceptions) {
                        String string3 = ExceptionUtils.getStackTrace(sAXException);
                        metadata.set(EMBEDDED_EXCEPTION, string3);
                        break block12;
                    }
                    throw sAXException;
                }
                catch (IOException | TikaException exception) {
                    if (RecursiveParserWrapper.this.catchEmbeddedExceptions) {
                        String string4 = ExceptionUtils.getStackTrace(exception);
                        metadata.set(EMBEDDED_EXCEPTION, string4);
                        break block12;
                    }
                    throw exception;
                }
                finally {
                    parseContext.set(Parser.class, parser);
                    long l2 = new Date().getTime() - l;
                    metadata.set(PARSE_TIME_MILLIS, Long.toString(l2));
                }
            }
            if (RecursiveParserWrapper.this.maxEmbeddedResources > -1 && RecursiveParserWrapper.this.metadatas.size() >= RecursiveParserWrapper.this.maxEmbeddedResources) {
                RecursiveParserWrapper.this.hitMaxEmbeddedResources = true;
                return;
            }
            RecursiveParserWrapper.this.addContent(contentHandler2, metadata);
            RecursiveParserWrapper.this.metadatas.add(RecursiveParserWrapper.this.deepCopy(metadata));
        }
    }
}

