/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.accessor;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmAccessor;
import org.apache.tika.parser.chm.assertion.ChmAssert;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmItsfHeader
implements ChmAccessor<ChmItsfHeader> {
    private static final long serialVersionUID = 2215291838533213826L;
    private byte[] signature;
    private int version;
    private int header_len;
    private int unknown_000c;
    private long last_modified;
    private long lang_id;
    private byte[] dir_uuid = new byte[16];
    private byte[] stream_uuid = new byte[16];
    private long unknown_offset;
    private long unknown_len;
    private long dir_offset;
    private long dir_len;
    private long data_offset;
    private int dataRemained;
    private int currentPlace = 0;

    public ChmItsfHeader() {
        this.signature = "ITSF".getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new String(this.getSignature(), StandardCharsets.UTF_8) + " ");
        stringBuilder.append(this.getVersion() + " ");
        stringBuilder.append(this.getHeaderLen() + " ");
        stringBuilder.append(this.getUnknown_000c() + " ");
        stringBuilder.append(this.getLastModified() + " ");
        stringBuilder.append(this.getLangId() + " ");
        stringBuilder.append(String.valueOf(this.getDir_uuid()) + " ");
        stringBuilder.append(String.valueOf(this.getStream_uuid()) + " ");
        stringBuilder.append(this.getUnknownOffset() + " ");
        stringBuilder.append(this.getUnknownLen() + " ");
        stringBuilder.append(this.getDirOffset() + " ");
        stringBuilder.append(this.getDirLen() + " ");
        stringBuilder.append(this.getDataOffset() + " ");
        return stringBuilder.toString();
    }

    public byte[] getSignature() {
        return this.signature;
    }

    protected void setSignature(byte[] byArray) {
        this.signature = byArray;
    }

    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int n) {
        this.version = n;
    }

    public int getHeaderLen() {
        return this.header_len;
    }

    protected void setHeaderLen(int n) {
        this.header_len = n;
    }

    public int getUnknown_000c() {
        return this.unknown_000c;
    }

    protected void setUnknown_000c(int n) {
        this.unknown_000c = n;
    }

    public long getLastModified() {
        return this.last_modified;
    }

    protected void setLastModified(long l) {
        this.last_modified = l;
    }

    public long getLangId() {
        return this.lang_id;
    }

    protected void setLangId(long l) {
        this.lang_id = l;
    }

    public byte[] getDir_uuid() {
        return this.dir_uuid;
    }

    protected void setDir_uuid(byte[] byArray) {
        this.dir_uuid = byArray;
    }

    public byte[] getStream_uuid() {
        return this.stream_uuid;
    }

    protected void setStream_uuid(byte[] byArray) {
        this.stream_uuid = byArray;
    }

    public long getUnknownOffset() {
        return this.unknown_offset;
    }

    protected void setUnknownOffset(long l) {
        this.unknown_offset = l;
    }

    public long getUnknownLen() {
        return this.unknown_len;
    }

    protected void setUnknownLen(long l) {
        this.unknown_len = l;
    }

    public long getDirOffset() {
        return this.dir_offset;
    }

    protected void setDirOffset(long l) {
        this.dir_offset = l;
    }

    public long getDirLen() {
        return this.dir_len;
    }

    protected void setDirLen(long l) {
        this.dir_len = l;
    }

    public long getDataOffset() {
        return this.data_offset;
    }

    protected void setDataOffset(long l) {
        this.data_offset = l;
    }

    private void unmarshalCharArray(byte[] byArray, ChmItsfHeader chmItsfHeader, int n) throws TikaException {
        ChmAssert.assertChmAccessorParameters(byArray, chmItsfHeader, n);
        System.arraycopy(byArray, 0, chmItsfHeader.signature, 0, n);
        this.setCurrentPlace(this.getCurrentPlace() + n);
        this.setDataRemained(this.getDataRemained() - n);
    }

    private byte[] unmarshalUuid(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, this.getCurrentPlace(), byArray2, 0, n);
        this.setCurrentPlace(this.getCurrentPlace() + n);
        this.setDataRemained(this.getDataRemained() - n);
        return byArray2;
    }

    private long unmarshalUint64(byte[] byArray, long l) throws TikaException {
        byte[] byArray2 = new byte[8];
        if (8 > this.getDataRemained()) {
            throw new TikaException("8 > this.getDataRemained()");
        }
        int n = 7;
        for (int i = 8; i > 0; --i) {
            byArray2[n--] = byArray[this.getCurrentPlace()];
            this.setCurrentPlace(this.getCurrentPlace() + 1);
        }
        l = new BigInteger(byArray2).longValue();
        this.setDataRemained(this.getDataRemained() - 8);
        return l;
    }

    private int unmarshalInt32(byte[] byArray, int n) throws TikaException {
        ChmAssert.assertByteArrayNotNull(byArray);
        if (4 > this.getDataRemained()) {
            throw new TikaException("4 > dataLenght");
        }
        n = byArray[this.getCurrentPlace()] & 0xFF | (byArray[this.getCurrentPlace() + 1] & 0xFF) << 8 | (byArray[this.getCurrentPlace() + 2] & 0xFF) << 16 | (byArray[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        this.setDataRemained(this.getDataRemained() - 4);
        return n;
    }

    private long unmarshalUInt32(byte[] byArray, long l) throws TikaException {
        ChmAssert.assertByteArrayNotNull(byArray);
        if (4 > this.getDataRemained()) {
            throw new TikaException("4 > dataLenght");
        }
        l = byArray[this.getCurrentPlace()] | byArray[this.getCurrentPlace() + 1] << 8 | byArray[this.getCurrentPlace() + 2] << 16 | byArray[this.getCurrentPlace() + 3] << 24;
        this.setDataRemained(this.getDataRemained() - 4);
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        return l;
    }

    public static void main(String[] stringArray) {
    }

    private void setDataRemained(int n) {
        this.dataRemained = n;
    }

    private int getDataRemained() {
        return this.dataRemained;
    }

    private void setCurrentPlace(int n) {
        this.currentPlace = n;
    }

    private int getCurrentPlace() {
        return this.currentPlace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parse(byte[] byArray, ChmItsfHeader chmItsfHeader) throws TikaException {
        if (byArray.length < 88 || byArray.length > 96) {
            throw new TikaException("we only know how to deal with the 0x58 and 0x60 byte structures");
        }
        chmItsfHeader.setDataRemained(byArray.length);
        chmItsfHeader.unmarshalCharArray(byArray, chmItsfHeader, 4);
        chmItsfHeader.setVersion(chmItsfHeader.unmarshalInt32(byArray, chmItsfHeader.getVersion()));
        chmItsfHeader.setHeaderLen(chmItsfHeader.unmarshalInt32(byArray, chmItsfHeader.getHeaderLen()));
        chmItsfHeader.setUnknown_000c(chmItsfHeader.unmarshalInt32(byArray, chmItsfHeader.getUnknown_000c()));
        chmItsfHeader.setLastModified(chmItsfHeader.unmarshalUInt32(byArray, chmItsfHeader.getLastModified()));
        chmItsfHeader.setLangId(chmItsfHeader.unmarshalUInt32(byArray, chmItsfHeader.getLangId()));
        chmItsfHeader.setDir_uuid(chmItsfHeader.unmarshalUuid(byArray, chmItsfHeader.getDir_uuid(), 16));
        chmItsfHeader.setStream_uuid(chmItsfHeader.unmarshalUuid(byArray, chmItsfHeader.getStream_uuid(), 16));
        chmItsfHeader.setUnknownOffset(chmItsfHeader.unmarshalUint64(byArray, chmItsfHeader.getUnknownOffset()));
        chmItsfHeader.setUnknownLen(chmItsfHeader.unmarshalUint64(byArray, chmItsfHeader.getUnknownLen()));
        chmItsfHeader.setDirOffset(chmItsfHeader.unmarshalUint64(byArray, chmItsfHeader.getDirOffset()));
        chmItsfHeader.setDirLen(chmItsfHeader.unmarshalUint64(byArray, chmItsfHeader.getDirLen()));
        if (!new String(chmItsfHeader.getSignature(), StandardCharsets.UTF_8).equals("ITSF")) {
            throw new TikaException("seems not valid file");
        }
        if (chmItsfHeader.getVersion() == 2) {
            if (chmItsfHeader.getHeaderLen() < 88) {
                throw new TikaException("something wrong with header");
            }
        } else {
            if (chmItsfHeader.getVersion() != 3) throw new ChmParsingException("unsupported chm format");
            if (chmItsfHeader.getHeaderLen() < 96) {
                throw new TikaException("unknown v3 header lenght");
            }
        }
        if (chmItsfHeader.getVersion() == 3) {
            if (chmItsfHeader.getDataRemained() < 0) throw new TikaException("cannot set data offset, no data remained");
            chmItsfHeader.setDataOffset(chmItsfHeader.getDirOffset() + chmItsfHeader.getDirLen());
            return;
        } else {
            chmItsfHeader.setDataOffset(chmItsfHeader.getDirOffset() + chmItsfHeader.getDirLen());
        }
    }
}

