/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.accessor;

import java.nio.charset.StandardCharsets;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmAccessor;
import org.apache.tika.parser.chm.assertion.ChmAssert;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmLzxcControlData
implements ChmAccessor<ChmLzxcControlData> {
    private static final long serialVersionUID = -7897854774939631565L;
    private long size;
    private byte[] signature = "LZXC".getBytes(StandardCharsets.UTF_8);
    private long version;
    private long resetInterval;
    private long windowSize;
    private long windowsPerReset;
    private long unknown_18;
    private int dataRemained;
    private int currentPlace = 0;

    private int getDataRemained() {
        return this.dataRemained;
    }

    private void setDataRemained(int n) {
        this.dataRemained = n;
    }

    private int getCurrentPlace() {
        return this.currentPlace;
    }

    private void setCurrentPlace(int n) {
        this.currentPlace = n;
    }

    public long getSize() {
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    protected void setSignature(byte[] byArray) {
        this.signature = byArray;
    }

    public long getVersion() {
        return this.version;
    }

    protected void setVersion(long l) {
        this.version = l;
    }

    public long getResetInterval() {
        return this.resetInterval;
    }

    protected void setResetInterval(long l) {
        this.resetInterval = l;
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    protected void setWindowSize(long l) {
        this.windowSize = l;
    }

    public long getWindowsPerReset() {
        return this.windowsPerReset;
    }

    protected void setWindowsPerReset(long l) {
        this.windowsPerReset = l;
    }

    public long getUnknown_18() {
        return this.unknown_18;
    }

    protected void setUnknown_18(long l) {
        this.unknown_18 = l;
    }

    private long unmarshalUInt32(byte[] byArray, long l) throws ChmParsingException {
        assert (byArray != null && byArray.length > 0);
        if (4 > this.getDataRemained()) {
            throw new ChmParsingException("4 > dataLenght");
        }
        l = byArray[this.getCurrentPlace()] | byArray[this.getCurrentPlace() + 1] << 8 | byArray[this.getCurrentPlace() + 2] << 16 | byArray[this.getCurrentPlace() + 3] << 24;
        this.setDataRemained(this.getDataRemained() - 4);
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        return l;
    }

    private void unmarshalCharArray(byte[] byArray, ChmLzxcControlData chmLzxcControlData, int n) throws TikaException {
        ChmAssert.assertByteArrayNotNull(byArray);
        ChmAssert.assertChmAccessorNotNull(chmLzxcControlData);
        ChmAssert.assertPositiveInt(n);
        System.arraycopy(byArray, 4, chmLzxcControlData.getSignature(), 0, n);
        this.setCurrentPlace(this.getCurrentPlace() + n);
        this.setDataRemained(this.getDataRemained() - n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("size(unknown):=" + this.getSize() + ", ");
        stringBuilder.append("signature(Compression type identifier):=" + new String(this.getSignature(), StandardCharsets.UTF_8) + ", ");
        stringBuilder.append("version(Possibly numeric code for LZX):=" + this.getVersion() + System.getProperty("line.separator"));
        stringBuilder.append("resetInterval(The Huffman reset interval):=" + this.getResetInterval() + ", ");
        stringBuilder.append("windowSize:=" + this.getWindowSize() + ", ");
        stringBuilder.append("windowsPerReset(unknown (sometimes 2, sometimes 1, sometimes 0):=" + this.getWindowsPerReset() + ", ");
        stringBuilder.append("unknown_18:=" + this.getUnknown_18() + System.getProperty("line.separator"));
        return stringBuilder.toString();
    }

    @Override
    public void parse(byte[] byArray, ChmLzxcControlData chmLzxcControlData) throws TikaException {
        if (byArray == null || byArray.length < 24) {
            throw new ChmParsingException("we want at least 0x18 bytes");
        }
        chmLzxcControlData.setDataRemained(byArray.length);
        chmLzxcControlData.setSize(this.unmarshalUInt32(byArray, chmLzxcControlData.getSize()));
        chmLzxcControlData.unmarshalCharArray(byArray, chmLzxcControlData, 4);
        chmLzxcControlData.setVersion(this.unmarshalUInt32(byArray, chmLzxcControlData.getVersion()));
        chmLzxcControlData.setResetInterval(this.unmarshalUInt32(byArray, chmLzxcControlData.getResetInterval()));
        chmLzxcControlData.setWindowSize(this.unmarshalUInt32(byArray, chmLzxcControlData.getWindowSize()));
        chmLzxcControlData.setWindowsPerReset(this.unmarshalUInt32(byArray, chmLzxcControlData.getWindowsPerReset()));
        if (byArray.length >= 28) {
            chmLzxcControlData.setUnknown_18(this.unmarshalUInt32(byArray, chmLzxcControlData.getUnknown_18()));
        } else {
            chmLzxcControlData.setUnknown_18(0L);
        }
        if (chmLzxcControlData.getVersion() == 2L) {
            chmLzxcControlData.setWindowSize(this.getWindowSize() * 32768L);
        }
        if (chmLzxcControlData.getWindowSize() == 0L || chmLzxcControlData.getResetInterval() == 0L) {
            throw new ChmParsingException("window size / resetInterval should be more than zero");
        }
        if (chmLzxcControlData.getWindowSize() == 1L) {
            throw new ChmParsingException("window size / resetInterval should be more than 1");
        }
        if (!new String(chmLzxcControlData.getSignature(), StandardCharsets.UTF_8).equals("LZXC")) {
            throw new ChmParsingException("the signature does not seem to be correct");
        }
    }

    public static void main(String[] stringArray) {
    }
}

