/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.accessor;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmAccessor;
import org.apache.tika.parser.chm.assertion.ChmAssert;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmLzxcResetTable
implements ChmAccessor<ChmLzxcResetTable> {
    private static final long serialVersionUID = -8209574429411707460L;
    private long version;
    private long block_count;
    private long unknown;
    private long table_offset;
    private long uncompressed_len;
    private long compressed_len;
    private long block_len;
    private long[] block_address;
    private int dataRemained;
    private int currentPlace = 0;

    private int getDataRemained() {
        return this.dataRemained;
    }

    private void setDataRemained(int n) {
        this.dataRemained = n;
    }

    public long[] getBlockAddress() {
        return this.block_address;
    }

    public void setBlockAddress(long[] lArray) {
        this.block_address = lArray;
    }

    private int getCurrentPlace() {
        return this.currentPlace;
    }

    private void setCurrentPlace(int n) {
        this.currentPlace = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("version:=" + this.getVersion() + System.getProperty("line.separator"));
        stringBuilder.append("block_count:=" + this.getBlockCount() + System.getProperty("line.separator"));
        stringBuilder.append("unknown:=" + this.getUnknown() + System.getProperty("line.separator"));
        stringBuilder.append("table_offset:=" + this.getTableOffset() + System.getProperty("line.separator"));
        stringBuilder.append("uncompressed_len:=" + this.getUncompressedLen() + System.getProperty("line.separator"));
        stringBuilder.append("compressed_len:=" + this.getCompressedLen() + System.getProperty("line.separator"));
        stringBuilder.append("block_len:=" + this.getBlockLen() + System.getProperty("line.separator"));
        stringBuilder.append("block_addresses:=" + Arrays.toString(this.getBlockAddress()));
        return stringBuilder.toString();
    }

    private long[] enumerateBlockAddresses(byte[] byArray) throws TikaException {
        ChmAssert.assertByteArrayNotNull(byArray);
        if (this.getBlockCount() > 5000L) {
            this.setBlockCount(5000L);
        }
        if (this.getBlockCount() < 0L && this.getDataRemained() / 8 > 0) {
            this.setBlockCount(this.getDataRemained() / 8);
        }
        long[] lArray = new long[(int)this.getBlockCount()];
        int n = this.getDataRemained() / 8;
        for (int i = 0; i < n; ++i) {
            long l = -1L;
            try {
                lArray[i] = this.unmarshalUint64(byArray, l);
                continue;
            }
            catch (Exception exception) {
                throw new TikaException(exception.getMessage());
            }
        }
        return lArray;
    }

    private boolean validateParamaters(byte[] byArray, ChmLzxcResetTable chmLzxcResetTable) throws TikaException {
        int n = 0;
        ChmAssert.assertByteArrayNotNull(byArray);
        ++n;
        ChmAssert.assertChmAccessorNotNull(chmLzxcResetTable);
        return ++n == 2;
    }

    private long unmarshalUInt32(byte[] byArray, long l) throws TikaException {
        ChmAssert.assertByteArrayNotNull(byArray);
        l = byArray[this.getCurrentPlace()] & 0xFF | (byArray[this.getCurrentPlace() + 1] & 0xFF) << 8 | (byArray[this.getCurrentPlace() + 2] & 0xFF) << 16 | (byArray[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setDataRemained(this.getDataRemained() - 4);
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        return l;
    }

    private long unmarshalUint64(byte[] byArray, long l) throws TikaException {
        ChmAssert.assertByteArrayNotNull(byArray);
        byte[] byArray2 = new byte[8];
        int n = 7;
        for (int i = 8; i > 0; --i) {
            if (byArray.length <= this.getCurrentPlace()) {
                throw new TikaException("data is too small to calculate address block");
            }
            byArray2[n--] = byArray[this.getCurrentPlace()];
            this.setCurrentPlace(this.getCurrentPlace() + 1);
        }
        l = new BigInteger(byArray2).longValue();
        this.setDataRemained(this.getDataRemained() - 8);
        return l;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public long getBlockCount() {
        return this.block_count;
    }

    public void setBlockCount(long l) {
        this.block_count = l;
    }

    public long getUnknown() {
        return this.unknown;
    }

    public void setUnknown(long l) {
        this.unknown = l;
    }

    public long getTableOffset() {
        return this.table_offset;
    }

    public void setTableOffset(long l) {
        this.table_offset = l;
    }

    public long getUncompressedLen() {
        return this.uncompressed_len;
    }

    public void setUncompressedLen(long l) {
        this.uncompressed_len = l;
    }

    public long getCompressedLen() {
        return this.compressed_len;
    }

    public void setCompressedLen(long l) {
        this.compressed_len = l;
    }

    public long getBlockLen() {
        return this.block_len;
    }

    public void setBlockLlen(long l) {
        this.block_len = l;
    }

    @Override
    public void parse(byte[] byArray, ChmLzxcResetTable chmLzxcResetTable) throws TikaException {
        this.setDataRemained(byArray.length);
        if (this.validateParamaters(byArray, chmLzxcResetTable)) {
            chmLzxcResetTable.setVersion(this.unmarshalUInt32(byArray, chmLzxcResetTable.getVersion()));
            chmLzxcResetTable.setBlockCount(this.unmarshalUInt32(byArray, chmLzxcResetTable.getBlockCount()));
            chmLzxcResetTable.setUnknown(this.unmarshalUInt32(byArray, chmLzxcResetTable.getUnknown()));
            chmLzxcResetTable.setTableOffset(this.unmarshalUInt32(byArray, chmLzxcResetTable.getTableOffset()));
            chmLzxcResetTable.setUncompressedLen(this.unmarshalUint64(byArray, chmLzxcResetTable.getUncompressedLen()));
            chmLzxcResetTable.setCompressedLen(this.unmarshalUint64(byArray, chmLzxcResetTable.getCompressedLen()));
            chmLzxcResetTable.setBlockLlen(this.unmarshalUint64(byArray, chmLzxcResetTable.getBlockLen()));
            chmLzxcResetTable.setBlockAddress(this.enumerateBlockAddresses(byArray));
        }
        if (chmLzxcResetTable.getVersion() != 2L) {
            throw new ChmParsingException("does not seem currect version of chmLzxcResetTable");
        }
    }
}

