/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.assertion;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmAccessor;
import org.apache.tika.parser.chm.accessor.ChmLzxcResetTable;
import org.apache.tika.parser.chm.core.ChmCommons;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmAssert {
    public static final void assertChmBlockSegment(byte[] byArray, ChmLzxcResetTable chmLzxcResetTable, int n, int n2, int n3) throws TikaException {
        if (byArray == null) {
            throw new TikaException("data[] is null");
        }
        if (byArray.length <= 0) {
            throw new TikaException("data[] length should be greater than zero");
        }
        if (chmLzxcResetTable == null) {
            throw new TikaException("resetTable is null");
        }
        if (chmLzxcResetTable.getBlockAddress().length <= 1) {
            throw new TikaException("resetTable.getBlockAddress().length should be greater than zero");
        }
        if (n < 0) {
            throw new TikaException("blockNumber should be positive number");
        }
        if (n2 < 0) {
            throw new TikaException("lzxcBlockOffset should be positive number");
        }
        if (n3 < 0) {
            throw new TikaException("lzxcBlockLength should be positive number");
        }
    }

    public static final void assertInputStreamNotNull(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("input sream is null");
        }
    }

    public static final void assertChmAccessorParameters(byte[] byArray, ChmAccessor<?> chmAccessor, int n) throws ChmParsingException {
        ChmAssert.assertByteArrayNotNull(byArray);
        ChmAssert.assertChmAccessorNotNull(chmAccessor);
    }

    public static final void assertByteArrayNotNull(byte[] byArray) throws ChmParsingException {
        if (byArray == null) {
            throw new ChmParsingException("byte[] data is null");
        }
    }

    public static final void assertChmAccessorNotNull(ChmAccessor<?> chmAccessor) throws ChmParsingException {
        if (chmAccessor == null) {
            throw new ChmParsingException("chm header is null");
        }
    }

    public static final void assertDirectoryListingEntry(int n, String string, ChmCommons.EntryType entryType, int n2, int n3) throws ChmParsingException {
        if (n < 0) {
            throw new ChmParsingException("invalid name length");
        }
        if (string == null) {
            throw new ChmParsingException("invalid name");
        }
        if (entryType != ChmCommons.EntryType.COMPRESSED && entryType != ChmCommons.EntryType.UNCOMPRESSED) {
            throw new ChmParsingException("invalid compressed type, should be EntryType.COMPRESSED | EntryType.UNCOMPRESSED");
        }
        if (n2 < 0) {
            throw new ChmParsingException("invalid offset");
        }
        if (n3 < 0) {
            throw new ChmParsingException("invalid length");
        }
    }

    public static void assertCopyingDataIndex(int n, int n2) throws ChmParsingException {
        if (n >= n2) {
            throw new ChmParsingException("cannot parse chm file index > data.length");
        }
    }

    public static void assertPositiveInt(int n) throws ChmParsingException {
        if (n <= 0) {
            throw new ChmParsingException("resetTable.getBlockAddress().length should be greater than zero");
        }
    }
}

