/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.core;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmLzxcResetTable;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.assertion.ChmAssert;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmCommons {
    public static final int UNDEFINED = 0;
    public static final int VERBATIM = 1;
    public static final int ALIGNED_OFFSET = 2;
    public static final int UNCOMPRESSED = 3;

    private ChmCommons() {
    }

    public static void assertByteArrayNotNull(byte[] byArray) throws TikaException {
        if (byArray == null) {
            throw new TikaException("byte[] is null");
        }
    }

    public static int getWindowSize(int n) {
        int n2 = 0;
        while (n > 1) {
            n >>>= 1;
            ++n2;
        }
        return n2;
    }

    public static byte[] getChmBlockSegment(byte[] byArray, ChmLzxcResetTable chmLzxcResetTable, int n, int n2, int n3) throws TikaException {
        ChmAssert.assertChmBlockSegment(byArray, chmLzxcResetTable, n, n2, n3);
        int n4 = -1;
        n4 = n < chmLzxcResetTable.getBlockAddress().length - 1 ? (int)(chmLzxcResetTable.getBlockAddress()[n + 1] - chmLzxcResetTable.getBlockAddress()[n]) : (n >= chmLzxcResetTable.getBlockAddress().length ? 0 : (int)((long)n3 - chmLzxcResetTable.getBlockAddress()[n]));
        byte[] byArray2 = ChmCommons.copyOfRange(byArray, (int)((long)n2 + chmLzxcResetTable.getBlockAddress()[n]), (int)((long)n2 + chmLzxcResetTable.getBlockAddress()[n] + (long)n4));
        return byArray2 != null ? byArray2 : new byte[1];
    }

    public static String getLanguage(long l) {
        switch ((int)l) {
            case 1025: {
                return "Arabic";
            }
            case 1069: {
                return "Basque";
            }
            case 1027: {
                return "Catalan";
            }
            case 2052: {
                return "Chinese (Simplified)";
            }
            case 1028: {
                return "Chinese (Traditional)";
            }
            case 1029: {
                return "Czech";
            }
            case 1030: {
                return "Danish";
            }
            case 1043: {
                return "Dutch";
            }
            case 1033: {
                return "English (United States)";
            }
            case 1035: {
                return "Finnish";
            }
            case 1036: {
                return "French";
            }
            case 1031: {
                return "German";
            }
            case 1032: {
                return "Greek";
            }
            case 1037: {
                return "Hebrew";
            }
            case 1038: {
                return "Hungarian";
            }
            case 1040: {
                return "Italian";
            }
            case 1041: {
                return "Japanese";
            }
            case 1042: {
                return "Korean";
            }
            case 1044: {
                return "Norwegian";
            }
            case 1045: {
                return "Polish";
            }
            case 2070: {
                return "Portuguese";
            }
            case 1046: {
                return "Portuguese (Brazil)";
            }
            case 1049: {
                return "Russian";
            }
            case 1051: {
                return "Slovakian";
            }
            case 1060: {
                return "Slovenian";
            }
            case 3082: {
                return "Spanish";
            }
            case 1053: {
                return "Swedish";
            }
            case 1055: {
                return "Turkish";
            }
        }
        return "unknown - http://msdn.microsoft.com/en-us/library/bb165625%28VS.80%29.aspx";
    }

    public static boolean hasSkip(DirectoryListingEntry directoryListingEntry) {
        return directoryListingEntry.getName().startsWith("/$") || directoryListingEntry.getName().startsWith("/#") || directoryListingEntry.getName().startsWith("::");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(byte[][] byArray, String string) throws TikaException {
        FileOutputStream fileOutputStream = null;
        if (byArray != null && string != null && !ChmCommons.isEmpty(string)) {
            try {
                fileOutputStream = new FileOutputStream(string);
                for (byte[] byArray2 : byArray) {
                    fileOutputStream.write(byArray2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TikaException(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    public static void reverse(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n = 0;
        for (int i = byArray.length - 1; i > n; --i, ++n) {
            byte by = byArray[i];
            byArray[i] = byArray[n];
            byArray[n] = by;
        }
    }

    public static final int indexOfResetTableBlock(byte[] byArray, byte[] byArray2) throws ChmParsingException {
        return ChmCommons.indexOf(byArray, byArray2) - 4;
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) throws ChmParsingException {
        int[] nArray = null;
        int n = 0;
        int n2 = -1;
        if (byArray2 != null && byArray != null) {
            nArray = new int[byArray2.length];
            nArray[0] = -1;
        } else {
            throw new ChmParsingException("pattern and/or text should not be null");
        }
        while (n < byArray2.length - 1) {
            if (n2 == -1 || byArray2[n] == byArray2[n2]) {
                if (byArray2[++n] != byArray2[++n2]) {
                    nArray[n] = n2;
                    continue;
                }
                nArray[n] = nArray[n2];
                continue;
            }
            n2 = nArray[n2];
        }
        n2 = 0;
        n = 0;
        while (n < byArray.length && n2 < byArray2.length) {
            if (n2 == -1 || byArray2[n2] == byArray[n]) {
                ++n;
                ++n2;
                continue;
            }
            n2 = nArray[n2];
        }
        if (n2 == byArray2.length) {
            return n - n2;
        }
        return -1;
    }

    public static int indexOf(List<DirectoryListingEntry> list, String string) {
        int n = 0;
        for (DirectoryListingEntry directoryListingEntry : list) {
            if (directoryListingEntry.toString().contains(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        ChmCommons.checkCopyOfRangeParams(byArray, n, n2);
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, Math.min(byArray.length - n, n3));
        return byArray2;
    }

    private static void checkCopyOfRangeParams(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("array is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException(n + " should be > 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(n2 + " should be > 0");
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static enum IntelState {
        STARTED,
        NOT_STARTED;

    }

    public static enum LzxState {
        STARTED_DECODING,
        NOT_STARTED_DECODING;

    }

    public static enum EntryType {
        UNCOMPRESSED,
        COMPRESSED;

    }
}

