/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.lzx;

import java.math.BigInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.core.ChmCommons;
import org.apache.tika.parser.chm.core.ChmConstants;
import org.apache.tika.parser.chm.exception.ChmParsingException;
import org.apache.tika.parser.chm.lzx.ChmLzxState;
import org.apache.tika.parser.chm.lzx.ChmSection;

public class ChmLzxBlock {
    private int block_number;
    private long block_length;
    private ChmLzxState state;
    private byte[] content = null;
    private ChmSection chmSection = null;
    private int contentLength = 0;
    private int previousBlockType = -1;

    public ChmLzxBlock(int n, byte[] byArray, long l, ChmLzxBlock chmLzxBlock) throws TikaException {
        if (this.validateConstructorParams(n, byArray, l)) {
            this.setBlockNumber(n);
            if (chmLzxBlock != null && chmLzxBlock.getState().getBlockLength() > chmLzxBlock.getState().getBlockRemaining()) {
                this.setChmSection(new ChmSection(byArray, chmLzxBlock.getContent()));
            } else {
                this.setChmSection(new ChmSection(byArray));
            }
            this.setBlockLength(l);
            this.checkLzxBlock(chmLzxBlock);
            if (chmLzxBlock == null || l < (long)((int)this.getBlockLength())) {
                this.setContent((int)this.getBlockLength());
            } else {
                this.setContent((int)l);
            }
            if (chmLzxBlock != null && chmLzxBlock.getState() != null) {
                this.previousBlockType = chmLzxBlock.getState().getBlockType();
            }
        } else {
            throw new TikaException("Check your chm lzx block parameters");
        }
        this.extractContent();
    }

    protected int getContentLength() {
        return this.contentLength;
    }

    protected void setContentLength(int n) {
        this.contentLength = n;
    }

    private ChmSection getChmSection() {
        return this.chmSection;
    }

    private void setChmSection(ChmSection chmSection) {
        this.chmSection = chmSection;
    }

    private void assertStateNotNull() throws TikaException {
        if (this.getState() == null) {
            throw new ChmParsingException("state is null");
        }
    }

    private void extractContent() throws TikaException {
        this.assertStateNotNull();
        if (this.getChmSection().getData() != null) {
            boolean bl = true;
            while (bl && (long)this.getContentLength() < this.getBlockLength()) {
                int n;
                if (this.getState() != null && this.getState().getBlockRemaining() == 0) {
                    if (this.getState().getHadStarted() == ChmCommons.LzxState.NOT_STARTED_DECODING) {
                        this.getState().setHadStarted(ChmCommons.LzxState.STARTED_DECODING);
                        if (this.getChmSection().getSyncBits(1) == 1) {
                            n = (this.getChmSection().getSyncBits(16) << 16) + this.getChmSection().getSyncBits(16);
                            if (n >= 0) {
                                this.getState().setIntelFileSize(n);
                            } else {
                                this.getState().setIntelFileSize(0);
                            }
                        }
                    }
                    this.getState().setBlockType(this.getChmSection().getSyncBits(3));
                    this.getState().setBlockLength((this.getChmSection().getSyncBits(16) << 8) + this.getChmSection().getSyncBits(8));
                    this.getState().setBlockRemaining(this.getState().getBlockLength());
                    if (this.getState().getBlockType() > 3 && this.previousBlockType >= 0 && this.previousBlockType < 3) {
                        this.getState().setBlockType(this.previousBlockType);
                    }
                    switch (this.getState().getBlockType()) {
                        case 2: {
                            this.createAlignedTreeTable();
                        }
                        case 1: {
                            this.createMainTreeTable();
                            this.createLengthTreeTable();
                            if (this.getState().getMainTreeLengtsTable()[232] == 0) break;
                            this.getState().setIntelState(ChmCommons.IntelState.STARTED);
                            break;
                        }
                        case 3: {
                            this.getState().setIntelState(ChmCommons.IntelState.STARTED);
                            if (this.getChmSection().getTotal() > 16) {
                                this.getChmSection().setSwath(this.getChmSection().getSwath() - 1);
                            }
                            this.getState().setR0(new BigInteger(this.getChmSection().reverseByteOrder(this.getChmSection().unmarshalBytes(4))).longValue());
                            this.getState().setR1(new BigInteger(this.getChmSection().reverseByteOrder(this.getChmSection().unmarshalBytes(4))).longValue());
                            this.getState().setR2(new BigInteger(this.getChmSection().reverseByteOrder(this.getChmSection().unmarshalBytes(4))).longValue());
                            break;
                        }
                    }
                }
                if ((long)(this.getContentLength() + this.getState().getBlockRemaining()) > this.getBlockLength()) {
                    this.getState().setBlockRemaining(this.getContentLength() + this.getState().getBlockRemaining() - (int)this.getBlockLength());
                    n = (int)this.getBlockLength();
                } else {
                    n = this.getContentLength() + this.getState().getBlockRemaining();
                    this.getState().setBlockRemaining(0);
                }
                int n2 = this.getContentLength();
                switch (this.getState().getBlockType()) {
                    case 2: {
                        this.decompressAlignedBlock(n, this.getChmSection().getPrevContent() == null ? this.getChmSection().getData() : this.getChmSection().getPrevContent());
                        break;
                    }
                    case 1: {
                        this.decompressVerbatimBlock(n, this.getChmSection().getPrevContent() == null ? this.getChmSection().getData() : this.getChmSection().getPrevContent());
                        break;
                    }
                    case 3: {
                        this.decompressUncompressedBlock(n, this.getChmSection().getPrevContent() == null ? this.getChmSection().getData() : this.getChmSection().getPrevContent());
                    }
                }
                this.getState().increaseFramesRead();
                if (this.getState().getFramesRead() < 32768 && this.getState().getIntelFileSize() != 0) {
                    this.intelE8Decoding();
                }
                bl = this.getContentLength() > n2;
            }
        }
    }

    protected void intelE8Decoding() {
        if (this.getBlockLength() <= 6L || this.getState().getIntelState() == ChmCommons.IntelState.NOT_STARTED) {
            this.getState().setBlockRemaining(this.getState().getBlockRemaining() - (int)this.getBlockLength());
        } else {
            long l = this.getState().getBlockRemaining();
            this.getState().setBlockRemaining(this.getState().getBlockRemaining() - (int)this.getBlockLength());
            int n = 0;
            while ((long)n < this.getBlockLength() - 10L) {
                if (this.content[n] != 232) {
                    ++n;
                    continue;
                }
                byte[] byArray = new byte[]{this.getContent()[n + 3], this.getContent()[n + 2], this.getContent()[n + 1], this.getContent()[n + 0]};
                long l2 = new BigInteger(byArray).longValue();
                if (l2 >= -l && l2 < (long)this.getState().getIntelFileSize()) {
                    long l3 = l2 >= 0L ? l2 - l : l2 + (long)this.getState().getIntelFileSize();
                    this.getContent()[n + 0] = (byte)l3;
                    this.getContent()[n + 1] = (byte)(l3 >>> 8);
                    this.getContent()[n + 2] = (byte)(l3 >>> 16);
                    this.getContent()[n + 3] = (byte)(l3 >>> 24);
                }
                n += 4;
                l += 5L;
            }
        }
    }

    private short[] createPreLenTable() {
        short[] sArray = new short[20];
        for (int i = 0; i < 20; ++i) {
            sArray[i] = (short)this.getChmSection().getSyncBits(4);
        }
        return sArray;
    }

    private void createLengthTreeTable() throws TikaException {
        short[] sArray = this.createPreLenTable();
        if (sArray == null) {
            throw new ChmParsingException("pretreetable is null");
        }
        short[] sArray2 = this.createTreeTable2(sArray, 104, 6, 20);
        if (sArray2 == null) {
            throw new ChmParsingException("pretreetable is null");
        }
        this.createLengthTreeLenTable(0, 249, sArray2, sArray);
        this.getState().setLengthTreeTable(this.createTreeTable2(this.getState().getLengthTreeLengtsTable(), 4596, 12, 249));
    }

    private void decompressUncompressedBlock(int n, byte[] byArray) {
        if ((long)(this.getContentLength() + this.getState().getBlockRemaining()) <= this.getBlockLength()) {
            for (int i = this.getContentLength(); i < this.getContentLength() + this.getState().getBlockRemaining(); ++i) {
                this.content[i] = this.getChmSection().getByte();
            }
            this.setContentLength(this.getContentLength() + this.getState().getBlockRemaining());
            this.getState().setBlockRemaining(0);
        } else {
            int n2 = this.getContentLength();
            while ((long)n2 < this.getBlockLength()) {
                this.content[n2] = this.getChmSection().getByte();
                ++n2;
            }
            this.getState().setBlockRemaining((int)this.getBlockLength() - this.getContentLength());
            this.setContentLength((int)this.getBlockLength());
        }
    }

    private void decompressAlignedBlock(int n, byte[] byArray) throws TikaException {
        if (this.getChmSection() == null || this.getState() == null || this.getState().getMainTreeTable() == null) {
            throw new ChmParsingException("chm section is null");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = this.getContentLength(); i < n; ++i) {
            int n5;
            int n6;
            int n7 = this.getChmSection().peekBits(12);
            if (n7 >= this.getState().mainTreeTable.length) {
                throw new ChmParsingException("error decompressing aligned block.");
            }
            short s = this.getState().mainTreeTable[this.getChmSection().peekBits(12)];
            if (s >= this.getState().getMainTreeElements()) {
                n6 = 12;
                do {
                    s = (short)(s << 1);
                    s = (short)(s + this.getChmSection().checkBit(++n6));
                } while ((s = this.getState().mainTreeTable[s]) >= this.getState().getMainTreeElements());
            }
            this.getChmSection().getSyncBits(this.getState().getMainTreeLengtsTable()[s]);
            if (s < 256) {
                this.content[i] = (byte)s;
                continue;
            }
            n2 = (s = (short)(s - 256)) & 7;
            if (n2 == 7) {
                n3 = this.getState().lengthTreeTable[this.getChmSection().peekBits(12)];
                if (n3 >= 250) {
                    n6 = 12;
                    do {
                        n3 <<= 1;
                        n3 += this.getChmSection().checkBit(++n6);
                    } while ((n3 = this.getState().lengthTreeTable[n3]) >= 249);
                }
                this.getChmSection().getSyncBits(this.getState().lengthTreeLengtsTable[n3]);
                n2 += n3;
            }
            n2 += 2;
            n4 = s >>> 3;
            if (n4 > 2) {
                int n8 = ChmConstants.EXTRA_BITS[n4];
                n4 = ChmConstants.POSITION_BASE[n4] - 2;
                if (n8 > 3) {
                    var13_13 = this.getChmSection().getSyncBits(n8 -= 3);
                    n4 = (int)((long)n4 + (var13_13 << 3));
                    int n9 = this.getChmSection().peekBits(7);
                    int n10 = this.getState().getAlignedTreeTable()[n9];
                    if (n10 >= this.getState().getMainTreeElements()) {
                        n6 = 7;
                        do {
                            n10 <<= 1;
                            n10 += this.getChmSection().checkBit(++n6);
                        } while ((n10 = this.getState().getAlignedTreeTable()[n10]) >= this.getState().getMainTreeElements());
                    }
                    this.getChmSection().getSyncBits(this.getState().getAlignedLenTable()[n10]);
                    n4 += n10;
                } else if (n8 == 3) {
                    int n11 = this.getChmSection().peekBits(7);
                    int n12 = this.getState().getAlignedTreeTable()[n11];
                    if (n12 >= this.getState().getMainTreeElements()) {
                        n6 = 7;
                        do {
                            n12 <<= 1;
                            n12 += this.getChmSection().checkBit(++n6);
                        } while ((n12 = this.getState().getAlignedTreeTable()[n12]) >= this.getState().getMainTreeElements());
                    }
                    this.getChmSection().getSyncBits(this.getState().getAlignedLenTable()[n12]);
                    n4 += n12;
                } else if (n8 > 0) {
                    var13_13 = this.getChmSection().getSyncBits(n8);
                    n4 = (int)((long)n4 + var13_13);
                } else {
                    n4 = 1;
                }
                this.getState().setR2(this.getState().getR1());
                this.getState().setR1(this.getState().getR0());
                this.getState().setR0(n4);
            } else if (n4 == 0) {
                n4 = (int)this.getState().getR0();
            } else if (n4 == 1) {
                n4 = (int)this.getState().getR1();
                this.getState().setR1(this.getState().getR0());
                this.getState().setR0(n4);
            } else {
                n4 = (int)this.getState().getR2();
                this.getState().setR2(this.getState().getR0());
                this.getState().setR0(n4);
            }
            int n13 = i;
            if ((i += n2 - 1) > n) break;
            if (n5 < 0) {
                if (n2 + n5 <= 0) {
                    n5 = byArray.length + n5;
                    while (n2-- > 0) {
                        this.content[n13++] = byArray[n5++];
                    }
                    continue;
                }
                n5 = byArray.length + n5;
                while (n5 < byArray.length) {
                    this.content[n13++] = byArray[n5++];
                }
                n2 = n2 + n5 - byArray.length;
                n5 = 0;
                while (n2-- > 0) {
                    this.content[n13++] = this.content[n5++];
                }
                continue;
            }
            for (n5 = n13 - n4; n5 < 0 && n2-- > 0; ++n5) {
                this.content[n13++] = this.content[(int)((long)n5 + this.getBlockLength())];
            }
            while (n2-- > 0) {
                this.content[n13++] = this.content[n5++];
            }
        }
        this.setContentLength(n);
    }

    private void assertShortArrayNotNull(short[] sArray) throws TikaException {
        if (sArray == null) {
            throw new ChmParsingException("short[] is null");
        }
    }

    private void decompressVerbatimBlock(int n, byte[] byArray) throws TikaException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = this.getContentLength(); i < n; ++i) {
            int n5;
            int n6;
            int n7 = this.getChmSection().peekBits(12);
            this.assertShortArrayNotNull(this.getState().getMainTreeTable());
            short s = this.getState().getMainTreeTable()[n7];
            if (s >= 512) {
                n6 = 12;
                do {
                    s = (short)(s << 1);
                    s = (short)(s + this.getChmSection().checkBit(++n6));
                } while ((s = this.getState().getMainTreeTable()[s]) >= 512);
            }
            this.getChmSection().getSyncBits(this.getState().getMainTreeLengtsTable()[s]);
            if (s < 256) {
                this.content[i] = (byte)s;
                continue;
            }
            n2 = (s = (short)(s - 256)) & 7;
            if (n2 == 7) {
                n3 = this.getState().getLengthTreeTable()[this.getChmSection().peekBits(12)];
                if (n3 >= 249) {
                    n6 = 12;
                    do {
                        n3 <<= 1;
                        n3 += this.getChmSection().checkBit(++n6);
                    } while ((n3 = this.getState().getLengthTreeTable()[n3]) >= 249);
                }
                this.getChmSection().getSyncBits(this.getState().getLengthTreeLengtsTable()[n3]);
                n2 += n3;
            }
            n2 += 2;
            n4 = s >>> 3;
            if (n4 > 2) {
                if (n4 != 3) {
                    short s2 = ChmConstants.EXTRA_BITS[n4];
                    long l = this.getChmSection().getSyncBits(s2);
                    n4 = (int)((long)(ChmConstants.POSITION_BASE[n4] - 2) + l);
                } else {
                    n4 = 1;
                }
                this.getState().setR2(this.getState().getR1());
                this.getState().setR1(this.getState().getR0());
                this.getState().setR0(n4);
            } else if (n4 == 0) {
                n4 = (int)this.getState().getR0();
            } else if (n4 == 1) {
                n4 = (int)this.getState().getR1();
                this.getState().setR1(this.getState().getR0());
                this.getState().setR0(n4);
            } else {
                n4 = (int)this.getState().getR2();
                this.getState().setR2(this.getState().getR0());
                this.getState().setR0(n4);
            }
            int n8 = i;
            if ((i += n2 - 1) > n) break;
            if (n5 < 0) {
                if (n2 + n5 <= 0) {
                    n5 = byArray.length + n5;
                    while (n2-- > 0 && byArray != null && n5 + 1 > 0) {
                        if (n8 >= this.content.length || n5 >= this.content.length) continue;
                        this.content[n8++] = byArray[n5++];
                    }
                    continue;
                }
                n5 = byArray.length + n5;
                while (n5 < byArray.length) {
                    if (n8 >= this.content.length || n5 >= this.content.length) continue;
                    this.content[n8++] = byArray[n5++];
                }
                n2 = n2 + n5 - byArray.length;
                n5 = 0;
                while (n2-- > 0) {
                    this.content[n8++] = this.content[n5++];
                }
                continue;
            }
            for (n5 = n8 - n4; n5 < 0 && n2-- > 0; ++n5) {
                this.content[n8++] = this.content[(int)((long)n5 + this.getBlockLength())];
            }
            while (n2-- > 0) {
                if (n8 >= this.content.length || n5 >= this.content.length) continue;
                this.content[n8++] = this.content[n5++];
            }
        }
        this.setContentLength(n);
    }

    private void createLengthTreeLenTable(int n, int n2, short[] sArray, short[] sArray2) throws TikaException {
        if (sArray2 == null || this.getChmSection() == null || sArray == null || sArray2 == null) {
            throw new ChmParsingException("is null");
        }
        int n3 = n;
        while (n3 < n2) {
            int n4;
            int n5;
            int n6;
            int n7 = sArray[this.getChmSection().peekBits(6)];
            if (n7 >= 20) {
                n6 = 6;
                do {
                    n7 <<= 1;
                    n7 += this.getChmSection().checkBit(++n6);
                } while ((n7 = sArray[n7]) >= 20);
            }
            this.getChmSection().getSyncBits(sArray2[n7]);
            if (n7 < 17) {
                n7 = this.getState().getLengthTreeLengtsTable()[n3] - n7;
                if (n7 < 0) {
                    n7 += 17;
                }
                this.getState().getLengthTreeLengtsTable()[n3] = (short)n7;
                ++n3;
                continue;
            }
            if (n7 == 17) {
                n5 = this.getChmSection().getSyncBits(4);
                n5 += 4;
                for (n4 = 0; n4 < n5; ++n4) {
                    if (n3 >= this.getState().getLengthTreeLengtsTable().length) continue;
                    this.getState().getLengthTreeLengtsTable()[n3++] = 0;
                }
                continue;
            }
            if (n7 == 18) {
                n5 = this.getChmSection().getSyncBits(5);
                n5 += 20;
                for (n4 = 0; n4 < n5; ++n4) {
                    this.getState().getLengthTreeLengtsTable()[n3++] = 0;
                }
                continue;
            }
            if (n7 != 19) continue;
            n5 = this.getChmSection().getSyncBits(1);
            n5 += 4;
            n7 = sArray[this.getChmSection().peekBits(6)];
            if (n7 >= 20) {
                n6 = 6;
                do {
                    n7 <<= 1;
                    n7 += this.getChmSection().checkBit(++n6);
                } while ((n7 = sArray[n7]) >= 20);
            }
            this.getChmSection().getSyncBits(sArray2[n7]);
            n7 = this.getState().getLengthTreeLengtsTable()[n3] - n7;
            if (n7 < 0) {
                n7 += 17;
            }
            for (n4 = 0; n4 < n5; ++n4) {
                this.getState().getLengthTreeLengtsTable()[n3++] = (short)n7;
            }
        }
    }

    private void createMainTreeTable() throws TikaException {
        short[] sArray = this.createPreLenTable();
        short[] sArray2 = this.createTreeTable2(sArray, 104, 6, 20);
        this.createMainTreeLenTable(0, 256, sArray2, sArray);
        sArray = this.createPreLenTable();
        sArray2 = this.createTreeTable2(sArray, 104, 6, 20);
        this.createMainTreeLenTable(256, this.getState().mainTreeLengtsTable.length, sArray2, sArray);
        this.getState().setMainTreeTable(this.createTreeTable2(this.getState().mainTreeLengtsTable, 5408, 12, this.getState().getMainTreeElements()));
    }

    private void createMainTreeLenTable(int n, int n2, short[] sArray, short[] sArray2) throws TikaException {
        if (sArray == null) {
            throw new ChmParsingException("pretreetable is null");
        }
        int n3 = n;
        while (n3 < n2) {
            int n4;
            int n5;
            int n6;
            int n7 = this.getChmSection().peekBits(6);
            int n8 = sArray[n7];
            if (n8 >= 20) {
                n6 = 6;
                do {
                    n8 <<= 1;
                    n8 += this.getChmSection().checkBit(++n6);
                } while ((n8 = sArray[n8]) >= 20);
            }
            this.getChmSection().getSyncBits(sArray2[n8]);
            if (n8 < 17) {
                n8 = this.getState().getMainTreeLengtsTable()[n3] - n8;
                if (n8 < 0) {
                    n8 += 17;
                }
                this.getState().mainTreeLengtsTable[n3] = (short)n8;
                ++n3;
                continue;
            }
            if (n8 == 17) {
                n5 = this.getChmSection().getSyncBits(4);
                n5 += 4;
                for (n4 = 0; n4 < n5; ++n4) {
                    this.assertInRange(this.getState().getMainTreeLengtsTable(), n3);
                    this.getState().mainTreeLengtsTable[n3++] = 0;
                }
                continue;
            }
            if (n8 == 18) {
                n5 = this.getChmSection().getSyncBits(5);
                n5 += 20;
                for (n4 = 0; n4 < n5; ++n4) {
                    this.assertInRange(this.getState().getMainTreeLengtsTable(), n3);
                    this.getState().mainTreeLengtsTable[n3++] = 0;
                }
                continue;
            }
            if (n8 != 19) continue;
            n5 = this.getChmSection().getSyncBits(1);
            n5 += 4;
            n8 = sArray[this.getChmSection().peekBits(6)];
            if (n8 >= 20) {
                n6 = 6;
                do {
                    n8 <<= 1;
                    n8 += this.getChmSection().checkBit(++n6);
                } while ((n8 = sArray[n8]) >= 20);
            }
            this.getChmSection().getSyncBits(sArray2[n8]);
            n8 = this.getState().mainTreeLengtsTable[n3] - n8;
            if (n8 < 0) {
                n8 += 17;
            }
            for (n4 = 0; n4 < n5; ++n4) {
                if (n3 >= this.getState().getMainTreeLengtsTable().length) continue;
                this.getState().mainTreeLengtsTable[n3++] = (short)n8;
            }
        }
    }

    private void assertInRange(short[] sArray, int n) throws ChmParsingException {
        if (n >= sArray.length) {
            throw new ChmParsingException(n + " is bigger than " + sArray.length);
        }
    }

    private short[] createAlignedLenTable() {
        int n = 8;
        int n2 = 3;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)this.getChmSection().getSyncBits(n2);
        }
        return sArray;
    }

    private void createAlignedTreeTable() throws ChmParsingException {
        this.getState().setAlignedLenTable(this.createAlignedLenTable());
        this.getState().setAlignedTreeTable(this.createTreeTable2(this.getState().getAlignedLenTable(), 144, 7, 8));
    }

    private short[] createTreeTable2(short[] sArray, int n, int n2, int n3) throws ChmParsingException {
        long l;
        int n4;
        int n5;
        int n6;
        long l2;
        short[] sArray2 = new short[n];
        int n7 = 0;
        long l3 = 1 << n2;
        long l4 = l2 = l3 >> 1;
        for (n6 = 1; n6 <= n2; ++n6) {
            for (n5 = 0; n5 < n3; n5 = (int)((short)(n5 + 1))) {
                if (sArray.length <= n5 || sArray[n5] != n6) continue;
                n4 = n7;
                if ((long)(n7 = (int)((long)n7 + l2)) > l3) {
                    throw new ChmParsingException("Table overflow");
                }
                l = l2;
                while (l-- > 0L) {
                    sArray2[n4++] = n5;
                }
            }
            l2 >>= 1;
        }
        if ((long)n7 != l3) {
            n4 = n7;
            while ((long)n4 < l3) {
                sArray2[n4] = 0;
                ++n4;
            }
            n7 <<= 16;
            l3 <<= 16;
            l2 = 32768L;
            while (n6 <= 16) {
                for (n5 = 0; n5 < n3; n5 = (int)((short)(n5 + 1))) {
                    if (sArray.length <= n5 || sArray[n5] != n6) continue;
                    n4 = n7 >> 16;
                    for (l = 0L; l < (long)(n6 - n2); ++l) {
                        if (sArray2[n4] == 0 && (l4 << 1) + 1L < (long)sArray2.length) {
                            sArray2[(int)(l4 << 1)] = 0;
                            sArray2[(int)(l4 << 1) + 1] = 0;
                            sArray2[n4] = (short)l4++;
                        }
                        n4 = sArray2[n4] << 1;
                        if ((n7 >> (int)(15L - l) & 1) == 0) continue;
                        ++n4;
                    }
                    sArray2[n4] = n5;
                    if ((long)(n7 = (int)((long)n7 + l2)) <= l3) continue;
                    throw new ChmParsingException("Table overflow");
                }
                l2 >>= 1;
                ++n6;
            }
        }
        if ((long)n7 == l3) {
            return sArray2;
        }
        return sArray2;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getContent(int n, int n2) {
        return this.getContent() != null ? ChmCommons.copyOfRange(this.getContent(), n, n2) : new byte[1];
    }

    public byte[] getContent(int n) {
        return this.getContent() != null ? ChmCommons.copyOfRange(this.getContent(), n, this.getContent().length) : new byte[1];
    }

    private void setContent(int n) {
        this.content = new byte[n];
    }

    private void checkLzxBlock(ChmLzxBlock chmLzxBlock) throws TikaException {
        if (chmLzxBlock == null && this.getBlockLength() < Integer.MAX_VALUE) {
            this.setState(new ChmLzxState((int)this.getBlockLength()));
        } else {
            this.setState(chmLzxBlock.getState().clone());
        }
    }

    private boolean validateConstructorParams(int n, byte[] byArray, long l) throws TikaException {
        int n2 = 0;
        if (n >= 0) {
            ++n2;
        } else {
            throw new ChmParsingException("block number should be possitive");
        }
        if (byArray != null && byArray.length > 0) {
            ++n2;
        } else {
            throw new ChmParsingException("data segment should not be null");
        }
        if (l <= 0L) {
            throw new ChmParsingException("block length should be more than zero");
        }
        return ++n2 == 3;
    }

    public int getBlockNumber() {
        return this.block_number;
    }

    private void setBlockNumber(int n) {
        this.block_number = n;
    }

    private long getBlockLength() {
        return this.block_length;
    }

    private void setBlockLength(long l) {
        this.block_length = l;
    }

    public ChmLzxState getState() {
        return this.state;
    }

    private void setState(ChmLzxState chmLzxState) {
        this.state = chmLzxState;
    }
}

