/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.LyricsHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ID3v1Handler
implements ID3Tags {
    private String title;
    private String artist;
    private String album;
    private String year;
    private ID3Tags.ID3Comment comment;
    private String genre;
    private String trackNumber;
    boolean found = false;

    public ID3v1Handler(InputStream inputStream, ContentHandler contentHandler) throws IOException, SAXException, TikaException {
        this(LyricsHandler.getSuffix(inputStream, 128));
    }

    protected ID3v1Handler(byte[] byArray) throws IOException, SAXException, TikaException {
        if (byArray.length == 128 && byArray[0] == 84 && byArray[1] == 65 && byArray[2] == 71) {
            this.found = true;
            this.title = ID3v1Handler.getString(byArray, 3, 33);
            this.artist = ID3v1Handler.getString(byArray, 33, 63);
            this.album = ID3v1Handler.getString(byArray, 63, 93);
            this.year = ID3v1Handler.getString(byArray, 93, 97);
            String string = ID3v1Handler.getString(byArray, 97, 127);
            this.comment = new ID3Tags.ID3Comment(string);
            int n = byArray[127] & 0xFF;
            this.genre = GENRES[Math.min(n, GENRES.length - 1)];
            if (byArray[125] == 0 && byArray[126] != 0) {
                int n2 = byArray[126] & 0xFF;
                this.trackNumber = Integer.toString(n2);
            }
        }
    }

    @Override
    public boolean getTagsPresent() {
        return this.found;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public List<ID3Tags.ID3Comment> getComments() {
        return Arrays.asList(this.comment);
    }

    @Override
    public String getGenre() {
        return this.genre;
    }

    @Override
    public String getTrackNumber() {
        return this.trackNumber;
    }

    @Override
    public String getComposer() {
        return null;
    }

    @Override
    public String getAlbumArtist() {
        return null;
    }

    @Override
    public String getDisc() {
        return null;
    }

    @Override
    public String getCompilation() {
        return null;
    }

    private static String getString(byte[] byArray, int n, int n2) throws TikaException {
        for (int i = n; i < n2 && byArray[i] != 0; ++i) {
        }
        for (n2 = i; n < n2 && byArray[n2 - 1] <= 32; --n2) {
        }
        while (n < n2 && byArray[n] <= 32) {
            ++n;
        }
        return new String(byArray, n, n2 - n, StandardCharsets.ISO_8859_1);
    }
}

