/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.ID3v22Handler;
import org.apache.tika.parser.mp3.ID3v2Frame;
import org.xml.sax.SAXException;

public class ID3v23Handler
implements ID3Tags {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String composer;
    private String genre;
    private String trackNumber;
    private String albumArtist;
    private String disc;
    private String compilation;
    private List<ID3Tags.ID3Comment> comments = new ArrayList<ID3Tags.ID3Comment>();

    public ID3v23Handler(ID3v2Frame iD3v2Frame) throws IOException, SAXException, TikaException {
        RawV23TagIterator rawV23TagIterator = new RawV23TagIterator(this, iD3v2Frame);
        while (rawV23TagIterator.hasNext()) {
            ID3v2Frame.RawTag rawTag = rawV23TagIterator.next();
            if (rawTag.name.equals("TIT2")) {
                this.title = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TPE1")) {
                this.artist = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TPE2")) {
                this.albumArtist = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TALB")) {
                this.album = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TYER")) {
                this.year = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TCOM")) {
                this.composer = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("COMM")) {
                this.comments.add(this.getComment(rawTag.data, 0, rawTag.data.length));
                continue;
            }
            if (rawTag.name.equals("TRCK")) {
                this.trackNumber = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TPOS")) {
                this.disc = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TCMP")) {
                this.compilation = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (!rawTag.name.equals("TCON")) continue;
            this.genre = ID3v22Handler.extractGenre(this.getTagString(rawTag.data, 0, rawTag.data.length));
        }
    }

    private String getTagString(byte[] byArray, int n, int n2) {
        return ID3v2Frame.getTagString(byArray, n, n2);
    }

    private ID3Tags.ID3Comment getComment(byte[] byArray, int n, int n2) {
        return ID3v2Frame.getComment(byArray, n, n2);
    }

    @Override
    public boolean getTagsPresent() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public String getComposer() {
        return this.composer;
    }

    @Override
    public List<ID3Tags.ID3Comment> getComments() {
        return this.comments;
    }

    @Override
    public String getGenre() {
        return this.genre;
    }

    @Override
    public String getTrackNumber() {
        return this.trackNumber;
    }

    @Override
    public String getAlbumArtist() {
        return this.albumArtist;
    }

    @Override
    public String getDisc() {
        return this.disc;
    }

    @Override
    public String getCompilation() {
        return this.compilation;
    }

    private class RawV23TagIterator
    extends ID3v2Frame.RawTagIterator {
        private RawV23TagIterator(ID3v23Handler iD3v23Handler, ID3v2Frame iD3v2Frame) {
            ID3v2Frame iD3v2Frame2 = iD3v2Frame;
            Objects.requireNonNull(iD3v2Frame2);
            super(iD3v2Frame2, 4, 4, 1, 2);
        }
    }
}

