/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.MP3Frame;

public class ID3v2Frame
implements MP3Frame {
    private int majorVersion;
    private int minorVersion;
    private int flags;
    private int length;
    private byte[] extendedHeader;
    private byte[] data;
    protected static final TextEncoding[] encodings = new TextEncoding[]{new TextEncoding("ISO-8859-1", false), new TextEncoding("UTF-16", true), new TextEncoding("UTF-16BE", true), new TextEncoding("UTF-8", false)};

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getExtendedHeader() {
        return this.extendedHeader;
    }

    public byte[] getData() {
        return this.data;
    }

    public static MP3Frame createFrameIfPresent(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n == 73 && n2 == 68 && n3 == 51) {
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            if (n4 == -1 || n5 == -1) {
                ID3v2Frame.pushBack(inputStream, n, n2, n3, n4, n5);
                return null;
            }
            return new ID3v2Frame(n4, n5, inputStream);
        }
        ID3v2Frame.pushBack(inputStream, n, n2, n3);
        return null;
    }

    private static void pushBack(InputStream inputStream, int ... nArray) throws IOException {
        if (inputStream instanceof PushbackInputStream) {
            byte[] byArray = new byte[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i] = (byte)nArray[i];
            }
            ((PushbackInputStream)inputStream).unread(byArray);
        }
    }

    private ID3v2Frame(int n, int n2, InputStream inputStream) throws IOException {
        this.majorVersion = n;
        this.minorVersion = n2;
        this.flags = inputStream.read();
        this.length = ID3v2Frame.get7BitsInt(ID3v2Frame.readFully(inputStream, 4), 0);
        if ((this.flags & 2) == 2) {
            int n3 = ID3v2Frame.getInt(ID3v2Frame.readFully(inputStream, 4));
            this.extendedHeader = ID3v2Frame.readFully(inputStream, n3);
        }
        this.data = ID3v2Frame.readFully(inputStream, this.length, false);
    }

    protected static int getInt(byte[] byArray) {
        return ID3v2Frame.getInt(byArray, 0);
    }

    protected static int getInt(byte[] byArray, int n) {
        int n2 = byArray[n + 0] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = byArray[n + 2] & 0xFF;
        int n5 = byArray[n + 3] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    protected static int getInt3(byte[] byArray, int n) {
        int n2 = byArray[n + 0] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = byArray[n + 2] & 0xFF;
        return (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    protected static int getInt2(byte[] byArray, int n) {
        int n2 = byArray[n + 0] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (n2 << 8) + (n3 << 0);
    }

    protected static int get7BitsInt(byte[] byArray, int n) {
        int n2 = byArray[n + 0] & 0x7F;
        int n3 = byArray[n + 1] & 0x7F;
        int n4 = byArray[n + 2] & 0x7F;
        int n5 = byArray[n + 3] & 0x7F;
        return (n2 << 21) + (n3 << 14) + (n4 << 7) + (n5 << 0);
    }

    protected static byte[] readFully(InputStream inputStream, int n) throws IOException {
        return ID3v2Frame.readFully(inputStream, n, true);
    }

    protected static byte[] readFully(InputStream inputStream, int n, boolean bl) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, i, n - i);
            if (n2 != -1) continue;
            if (bl) {
                throw new IOException("Tried to read " + n + " bytes, but only " + i + " bytes present");
            }
            return byArray;
        }
        return byArray;
    }

    protected static String getTagString(byte[] byArray, int n, int n2) {
        int n3 = n2;
        if (n3 == 0) {
            return "";
        }
        if (n3 == 1 && byArray[n] == 0) {
            return "";
        }
        TextEncoding textEncoding = encodings[0];
        byte by = byArray[n];
        if (by >= 0 && by < encodings.length) {
            ++n;
            --n3;
            textEncoding = encodings[by];
        }
        while (textEncoding.doubleByte && n3 >= 2 && byArray[n + n3 - 1] == 0 && byArray[n + n3 - 2] == 0) {
            n3 -= 2;
        }
        while (!textEncoding.doubleByte && n3 >= 1 && byArray[n + n3 - 1] == 0) {
            --n3;
        }
        if (n3 == 0) {
            return "";
        }
        if (textEncoding.encoding.equals("UTF-16") && n3 == 2 && (byArray[n] == -1 && byArray[n + 1] == -2 || byArray[n] == -2 && byArray[n + 1] == -1)) {
            return "";
        }
        try {
            return new String(byArray, n, n3, textEncoding.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Core encoding " + textEncoding.encoding + " is not available", unsupportedEncodingException);
        }
    }

    protected static ID3Tags.ID3Comment getComment(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        if (by < 0 || by >= encodings.length) {
            return null;
        }
        TextEncoding textEncoding = encodings[by];
        String string = ID3v2Frame.getString(byArray, n + 1, 3);
        int n3 = n + 4;
        int n4 = -1;
        String string2 = null;
        String string3 = null;
        try {
            for (int i = n3; i < n + n2; ++i) {
                if (textEncoding.doubleByte && byArray[i] == 0 && byArray[i + 1] == 0) {
                    if (i + 2 < n + n2 && byArray[i + 1] == 0 && byArray[i + 2] == 0) {
                        ++i;
                    }
                    n4 = i + 2;
                    string2 = new String(byArray, n3, i - n3, textEncoding.encoding);
                    break;
                }
                if (textEncoding.doubleByte || byArray[i] != 0) continue;
                n4 = i + 1;
                string2 = new String(byArray, n3, i - n3, textEncoding.encoding);
                break;
            }
            string3 = n4 > -1 ? new String(byArray, n4, n + n2 - n4, textEncoding.encoding) : new String(byArray, n3, n + n2 - n3, textEncoding.encoding);
            return new ID3Tags.ID3Comment(string, string2, string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Core encoding " + textEncoding.encoding + " is not available", unsupportedEncodingException);
        }
    }

    protected static String getString(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, StandardCharsets.ISO_8859_1);
    }

    protected static class TextEncoding {
        public final boolean doubleByte;
        public final String encoding;

        private TextEncoding(String string, boolean bl) {
            this.doubleByte = bl;
            this.encoding = string;
        }
    }

    protected static class RawTag {
        private int headerSize;
        protected String name;
        protected int flag;
        protected byte[] data;

        private RawTag(int n, int n2, int n3, int n4, byte[] byArray, int n5) {
            this.headerSize = n + n2 + n4;
            this.name = ID3v2Frame.getString(byArray, n5, n);
            int n6 = n2 == 3 ? ID3v2Frame.getInt3(byArray, n5 + n) : ID3v2Frame.getInt(byArray, n5 + n);
            int n7 = n6 * n3;
            if (n4 > 0) {
                this.flag = n4 == 1 ? byArray[n5 + n + n2] : ID3v2Frame.getInt2(byArray, n5 + n + n2);
            }
            int n8 = n5 + n + n2 + n4;
            n7 = Math.max(0, Math.min(n7, byArray.length - n8));
            this.data = new byte[n7];
            System.arraycopy(byArray, n8, this.data, 0, n7);
        }

        protected int getSize() {
            return this.headerSize + this.data.length;
        }
    }

    protected class RawTagIterator
    implements Iterator<RawTag> {
        private int nameLength;
        private int sizeLength;
        private int sizeMultiplier;
        private int flagLength;
        private int offset = 0;

        protected RawTagIterator(int n, int n2, int n3, int n4) {
            this.nameLength = n;
            this.sizeLength = n2;
            this.sizeMultiplier = n3;
            this.flagLength = n4;
        }

        @Override
        public boolean hasNext() {
            return this.offset < ID3v2Frame.this.data.length && ID3v2Frame.this.data[this.offset] != 0;
        }

        @Override
        public RawTag next() {
            RawTag rawTag = new RawTag(this.nameLength, this.sizeLength, this.sizeMultiplier, this.flagLength, ID3v2Frame.this.data, this.offset);
            this.offset += rawTag.getSize();
            return rawTag;
        }

        @Override
        public void remove() {
        }
    }
}

