/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3v1Handler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LyricsHandler {
    boolean foundLyrics = false;
    String lyricsText = null;
    ID3v1Handler id3v1 = null;

    public LyricsHandler(InputStream inputStream, ContentHandler contentHandler) throws IOException, SAXException, TikaException {
        this(LyricsHandler.getSuffix(inputStream, 10368));
    }

    protected LyricsHandler(byte[] byArray) throws IOException, SAXException, TikaException {
        if (byArray.length < 128) {
            return;
        }
        byte[] byArray2 = new byte[128];
        System.arraycopy(byArray, byArray.length - 128, byArray2, 0, 128);
        this.id3v1 = new ID3v1Handler(byArray2);
        if (byArray.length < 137) {
            return;
        }
        int n = byArray.length - 9;
        if (this.id3v1.found) {
            n -= 128;
        }
        if (byArray[n + 0] == 76 && byArray[n + 1] == 89 && byArray[n + 2] == 82 && byArray[n + 3] == 73 && byArray[n + 4] == 67 && byArray[n + 5] == 83 && byArray[n + 6] == 50 && byArray[n + 7] == 48 && byArray[n + 8] == 48) {
            this.foundLyrics = true;
            int n2 = Integer.parseInt(new String(byArray, n - 6, 6, StandardCharsets.UTF_8));
            String string = new String(byArray, n - n2 + 5, n2 - 11, StandardCharsets.US_ASCII);
            int n3 = 0;
            while (n3 < string.length() - 8) {
                String string2 = string.substring(n3, n3 + 3);
                int n4 = Integer.parseInt(string.substring(n3 + 3, n3 + 8));
                int n5 = n3 + 8;
                int n6 = n5 + n4;
                if (string2.equals("LYR")) {
                    this.lyricsText = string.substring(n5, n6);
                }
                n3 = n6;
            }
        }
    }

    public boolean hasID3v1() {
        return this.id3v1 != null && this.id3v1.found;
    }

    public boolean hasLyrics() {
        return this.lyricsText != null && this.lyricsText.length() > 0;
    }

    protected static byte[] getSuffix(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[2 * n];
        int n2 = 0;
        int n3 = inputStream.read(byArray);
        while (n3 != -1) {
            if ((n2 += n3) == byArray.length) {
                System.arraycopy(byArray, n2 - n, byArray, 0, n);
                n2 = n;
            }
            n3 = inputStream.read(byArray, n2, byArray.length - n2);
        }
        if (n2 < n) {
            n = n2;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, n2 - n, byArray2, 0, n);
        return byArray2;
    }
}

