/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TailStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mp3.AudioFrame;
import org.apache.tika.parser.mp3.CompositeTagHandler;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.ID3v1Handler;
import org.apache.tika.parser.mp3.ID3v22Handler;
import org.apache.tika.parser.mp3.ID3v23Handler;
import org.apache.tika.parser.mp3.ID3v24Handler;
import org.apache.tika.parser.mp3.ID3v2Frame;
import org.apache.tika.parser.mp3.LyricsHandler;
import org.apache.tika.parser.mp3.MP3Frame;
import org.apache.tika.parser.mp3.MpegStream;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Mp3Parser
extends AbstractParser {
    private static final long serialVersionUID = 8537074922934844370L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.audio("mpeg"));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", "audio/mpeg");
        metadata.set(XMPDM.AUDIO_COMPRESSOR, "MP3");
        XHTMLContentHandler xHTMLContentHandler = new XHTMLContentHandler(contentHandler, metadata);
        xHTMLContentHandler.startDocument();
        ID3TagsAndAudio iD3TagsAndAudio = Mp3Parser.getAllTagHandlers(inputStream, contentHandler);
        if (iD3TagsAndAudio.tags.length > 0) {
            CompositeTagHandler compositeTagHandler = new CompositeTagHandler(iD3TagsAndAudio.tags);
            metadata.set(TikaCoreProperties.TITLE, compositeTagHandler.getTitle());
            metadata.set(TikaCoreProperties.CREATOR, compositeTagHandler.getArtist());
            metadata.set(XMPDM.ARTIST, compositeTagHandler.getArtist());
            metadata.set(XMPDM.ALBUM_ARTIST, compositeTagHandler.getAlbumArtist());
            metadata.set(XMPDM.COMPOSER, compositeTagHandler.getComposer());
            metadata.set(XMPDM.ALBUM, compositeTagHandler.getAlbum());
            metadata.set(XMPDM.COMPILATION, compositeTagHandler.getCompilation());
            metadata.set(XMPDM.RELEASE_DATE, compositeTagHandler.getYear());
            metadata.set(XMPDM.GENRE, compositeTagHandler.getGenre());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ID3Tags.ID3Comment object : compositeTagHandler.getComments()) {
                StringBuffer stringBuffer = new StringBuffer();
                if (object.getLanguage() != null) {
                    stringBuffer.append(object.getLanguage());
                    stringBuffer.append(" - ");
                }
                if (object.getDescription() != null) {
                    stringBuffer.append(object.getDescription());
                    if (object.getText() != null) {
                        stringBuffer.append("\n");
                    }
                }
                if (object.getText() != null) {
                    stringBuffer.append(object.getText());
                }
                arrayList.add(stringBuffer.toString());
                metadata.add(XMPDM.LOG_COMMENT.getName(), stringBuffer.toString());
            }
            xHTMLContentHandler.element("h1", compositeTagHandler.getTitle());
            xHTMLContentHandler.element("p", compositeTagHandler.getArtist());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(compositeTagHandler.getAlbum());
            if (compositeTagHandler.getTrackNumber() != null) {
                stringBuilder.append(", track ").append(compositeTagHandler.getTrackNumber());
                metadata.set(XMPDM.TRACK_NUMBER, compositeTagHandler.getTrackNumber());
            }
            if (compositeTagHandler.getDisc() != null) {
                stringBuilder.append(", disc ").append(compositeTagHandler.getDisc());
                metadata.set(XMPDM.DISC_NUMBER, compositeTagHandler.getDisc());
            }
            xHTMLContentHandler.element("p", stringBuilder.toString());
            xHTMLContentHandler.element("p", compositeTagHandler.getYear());
            xHTMLContentHandler.element("p", compositeTagHandler.getGenre());
            xHTMLContentHandler.element("p", String.valueOf(iD3TagsAndAudio.duration));
            for (String string : arrayList) {
                xHTMLContentHandler.element("p", string);
            }
        }
        if (iD3TagsAndAudio.duration > 0.0f) {
            metadata.set(XMPDM.DURATION, iD3TagsAndAudio.duration);
        }
        if (iD3TagsAndAudio.audio != null) {
            metadata.set("samplerate", String.valueOf(iD3TagsAndAudio.audio.getSampleRate()));
            metadata.set("channels", String.valueOf(iD3TagsAndAudio.audio.getChannels()));
            metadata.set("version", iD3TagsAndAudio.audio.getVersion());
            metadata.set(XMPDM.AUDIO_SAMPLE_RATE, Integer.toString(iD3TagsAndAudio.audio.getSampleRate()));
            if (iD3TagsAndAudio.audio.getChannels() == 1) {
                metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Mono");
            } else if (iD3TagsAndAudio.audio.getChannels() == 2) {
                metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Stereo");
            } else if (iD3TagsAndAudio.audio.getChannels() == 5) {
                metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "5.1");
            } else if (iD3TagsAndAudio.audio.getChannels() == 7) {
                metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "7.1");
            }
        }
        if (iD3TagsAndAudio.lyrics != null && iD3TagsAndAudio.lyrics.hasLyrics()) {
            xHTMLContentHandler.startElement("p", "class", "lyrics");
            xHTMLContentHandler.characters(iD3TagsAndAudio.lyrics.lyricsText);
            xHTMLContentHandler.endElement("p");
        }
        xHTMLContentHandler.endDocument();
    }

    protected static ID3TagsAndAudio getAllTagHandlers(InputStream inputStream, ContentHandler contentHandler) throws IOException, SAXException, TikaException {
        MP3Frame mP3Frame;
        MP3Frame mP3Frame2;
        ID3v24Handler iD3v24Handler = null;
        ID3v23Handler iD3v23Handler = null;
        ID3v22Handler iD3v22Handler = null;
        ID3v1Handler iD3v1Handler = null;
        LyricsHandler lyricsHandler = null;
        MP3Frame mP3Frame3 = null;
        TailStream tailStream = new TailStream(inputStream, 10368);
        MpegStream mpegStream = new MpegStream(tailStream);
        while ((mP3Frame2 = ID3v2Frame.createFrameIfPresent(mpegStream)) != null) {
            if (!(mP3Frame2 instanceof ID3v2Frame)) continue;
            mP3Frame = (ID3v2Frame)mP3Frame2;
            if (((ID3v2Frame)mP3Frame).getMajorVersion() == 4) {
                iD3v24Handler = new ID3v24Handler((ID3v2Frame)mP3Frame);
                continue;
            }
            if (((ID3v2Frame)mP3Frame).getMajorVersion() == 3) {
                iD3v23Handler = new ID3v23Handler((ID3v2Frame)mP3Frame);
                continue;
            }
            if (((ID3v2Frame)mP3Frame).getMajorVersion() != 2) continue;
            iD3v22Handler = new ID3v22Handler((ID3v2Frame)mP3Frame);
        }
        mP3Frame = mpegStream.nextFrame();
        float f = 0.0f;
        while (mP3Frame != null) {
            f += ((AudioFrame)mP3Frame).getDuration();
            if (mP3Frame3 == null) {
                mP3Frame3 = mP3Frame;
            }
            mpegStream.skipFrame();
            mP3Frame = mpegStream.nextFrame();
        }
        lyricsHandler = new LyricsHandler(tailStream.getTail());
        iD3v1Handler = lyricsHandler.id3v1;
        ArrayList<ID3Tags> arrayList = new ArrayList<ID3Tags>();
        if (iD3v24Handler != null && iD3v24Handler.getTagsPresent()) {
            arrayList.add(iD3v24Handler);
        }
        if (iD3v23Handler != null && iD3v23Handler.getTagsPresent()) {
            arrayList.add(iD3v23Handler);
        }
        if (iD3v22Handler != null && iD3v22Handler.getTagsPresent()) {
            arrayList.add(iD3v22Handler);
        }
        if (iD3v1Handler != null && iD3v1Handler.getTagsPresent()) {
            arrayList.add(iD3v1Handler);
        }
        ID3TagsAndAudio iD3TagsAndAudio = new ID3TagsAndAudio();
        iD3TagsAndAudio.audio = mP3Frame3;
        iD3TagsAndAudio.lyrics = lyricsHandler;
        iD3TagsAndAudio.tags = arrayList.toArray(new ID3Tags[arrayList.size()]);
        iD3TagsAndAudio.duration = f;
        return iD3TagsAndAudio;
    }

    protected static class ID3TagsAndAudio {
        private ID3Tags[] tags;
        private AudioFrame audio;
        private LyricsHandler lyrics;
        private float duration;

        protected ID3TagsAndAudio() {
        }
    }
}

