/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.tika.parser.mp3.AudioFrame;

class MpegStream
extends PushbackInputStream {
    private static final int[] BIT_RATE_MPEG1_L1 = new int[]{0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000};
    private static final int[] BIT_RATE_MPEG1_L2 = new int[]{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000};
    private static final int[] BIT_RATE_MPEG1_L3 = new int[]{0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000};
    private static final int[] BIT_RATE_MPEG2_L1 = new int[]{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000};
    private static final int[] BIT_RATE_MPEG2_L2 = new int[]{0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000};
    private static final int[] SAMPLE_RATE_MPEG1 = new int[]{44100, 48000, 32000};
    private static final int[] SAMPLE_RATE_MPEG2 = new int[]{22050, 24000, 16000};
    private static final int[] SAMPLE_RATE_MPEG2_5 = new int[]{11025, 12000, 8000};
    private static final int[][] SAMPLE_RATE = MpegStream.createSampleRateTable();
    private static final int SAMPLE_COUNT_L1 = 384;
    private static final int SAMPLE_COUNT_L2 = 1152;
    private static final int HEADER_SIZE = 4;
    private AudioFrame currentHeader;
    private boolean endOfStream;

    public MpegStream(InputStream inputStream) {
        super(inputStream, 8);
    }

    public AudioFrame nextFrame() throws IOException {
        AudioFrame audioFrame = null;
        while (!this.endOfStream && audioFrame == null) {
            this.findFrameSyncByte();
            if (this.endOfStream) continue;
            HeaderBitField headerBitField = this.createHeaderField();
            if (this.endOfStream || (audioFrame = this.createHeader(headerBitField)) != null) continue;
            this.pushBack(headerBitField);
        }
        this.currentHeader = audioFrame;
        return audioFrame;
    }

    public boolean skipFrame() throws IOException {
        if (this.currentHeader != null) {
            MpegStream.skipStream(this.in, this.currentHeader.getLength() - 4);
            this.currentHeader = null;
            return true;
        }
        return false;
    }

    private void findFrameSyncByte() throws IOException {
        boolean bl = false;
        while (!bl && !this.endOfStream) {
            if (this.nextByte() != 255) continue;
            bl = true;
        }
    }

    private HeaderBitField createHeaderField() throws IOException {
        HeaderBitField headerBitField = new HeaderBitField();
        headerBitField.add(this.nextByte());
        headerBitField.add(this.nextByte());
        headerBitField.add(this.nextByte());
        return headerBitField;
    }

    private AudioFrame createHeader(HeaderBitField headerBitField) {
        if (headerBitField.get(21, 23) != 7) {
            return null;
        }
        int n = headerBitField.get(19, 20);
        int n2 = headerBitField.get(17, 18);
        int n3 = headerBitField.get(12, 15);
        int n4 = headerBitField.get(10, 11);
        int n5 = headerBitField.get(9);
        if (n == 1 || n2 == 0 || n3 == 0 || n3 == 15 || n4 == 3) {
            return null;
        }
        int n6 = MpegStream.calculateBitRate(n, n2, n3);
        int n7 = MpegStream.calculateSampleRate(n, n4);
        int n8 = MpegStream.calculateFrameLength(n2, n6, n7, n5);
        float f = MpegStream.calculateDuration(n2, n7);
        int n9 = MpegStream.calculateChannels(headerBitField.get(6, 7));
        return new AudioFrame(n, n2, n6, n7, n9, n8, f);
    }

    private int nextByte() throws IOException {
        int n = 0;
        if (!this.endOfStream && (n = this.read()) == -1) {
            this.endOfStream = true;
        }
        return this.endOfStream ? 0 : n;
    }

    private void pushBack(HeaderBitField headerBitField) throws IOException {
        this.unread(headerBitField.toArray());
    }

    private static void skipStream(InputStream inputStream, long l) throws IOException {
        long l2 = l;
        long l3 = 0L;
        while (l2 > 0L && l3 >= 0L) {
            l3 = inputStream.skip(l2);
            if (l3 == -1L) continue;
            l2 -= l3;
        }
    }

    private static int calculateBitRate(int n, int n2, int n3) {
        int[] nArray = null;
        if (n == 3) {
            switch (n2) {
                case 3: {
                    nArray = BIT_RATE_MPEG1_L1;
                    break;
                }
                case 2: {
                    nArray = BIT_RATE_MPEG1_L2;
                    break;
                }
                case 1: {
                    nArray = BIT_RATE_MPEG1_L3;
                }
            }
        } else {
            nArray = n2 == 3 ? BIT_RATE_MPEG2_L1 : BIT_RATE_MPEG2_L2;
        }
        return nArray[n3];
    }

    private static int calculateSampleRate(int n, int n2) {
        return SAMPLE_RATE[n][n2];
    }

    private static int calculateFrameLength(int n, int n2, int n3, int n4) {
        if (n == 3) {
            return (12 * n2 / n3 + n4) * 4;
        }
        return 144 * n2 / n3 + n4;
    }

    private static float calculateDuration(int n, int n2) {
        int n3 = n == 3 ? 384 : 1152;
        return 1000.0f / (float)n2 * (float)n3;
    }

    private static int calculateChannels(int n) {
        return n < 3 ? 2 : 1;
    }

    private static int[][] createSampleRateTable() {
        int[][] nArrayArray = new int[4][];
        nArrayArray[3] = SAMPLE_RATE_MPEG1;
        nArrayArray[2] = SAMPLE_RATE_MPEG2;
        nArrayArray[0] = SAMPLE_RATE_MPEG2_5;
        return nArrayArray;
    }

    private static class HeaderBitField {
        private int value;

        private HeaderBitField() {
        }

        public void add(int n) {
            this.value <<= 8;
            this.value |= n;
        }

        public int get(int n, int n2) {
            int n3 = this.value >> n;
            int n4 = (1 << n2 - n + 1) - 1;
            return n3 & n4;
        }

        public int get(int n) {
            return this.get(n, n);
        }

        public byte[] toArray() {
            byte[] byArray = new byte[]{(byte)this.get(16, 23), (byte)this.get(8, 15), (byte)this.get(0, 7)};
            return byArray;
        }
    }
}

