/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.MSOffice;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.odf.NSNormalizerContentHandler;
import org.apache.tika.parser.xml.AttributeDependantMetadataHandler;
import org.apache.tika.parser.xml.AttributeMetadataHandler;
import org.apache.tika.parser.xml.ElementMetadataHandler;
import org.apache.tika.parser.xml.MetadataHandler;
import org.apache.tika.parser.xml.XMLParser;
import org.apache.tika.sax.TeeContentHandler;
import org.apache.tika.sax.xpath.CompositeMatcher;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.MatchingContentHandler;
import org.apache.tika.sax.xpath.XPathParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OpenDocumentMetaParser
extends XMLParser {
    private static final long serialVersionUID = -8739250869531737584L;
    private static final String META_NS = "urn:oasis:names:tc:opendocument:xmlns:meta:1.0";
    private static final XPathParser META_XPATH = new XPathParser("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
    @Deprecated
    private static final Property TRANSITION_INITIAL_CREATOR_TO_INITIAL_AUTHOR = Property.composite(Office.INITIAL_AUTHOR, new Property[]{Property.externalText("initial-creator")});

    private static ContentHandler getDublinCoreHandler(Metadata metadata, Property property, String string) {
        return new ElementMetadataHandler("http://purl.org/dc/elements/1.1/", string, metadata, property);
    }

    private static ContentHandler getMeta(ContentHandler contentHandler, Metadata metadata, Property property, String string) {
        CompositeMatcher compositeMatcher = new CompositeMatcher(META_XPATH.parse("//meta:" + string), META_XPATH.parse("//meta:" + string + "//text()"));
        MatchingContentHandler matchingContentHandler = new MatchingContentHandler(new MetadataHandler(metadata, property), compositeMatcher);
        return new TeeContentHandler(contentHandler, matchingContentHandler);
    }

    private static ContentHandler getUserDefined(ContentHandler contentHandler, Metadata metadata) {
        CompositeMatcher compositeMatcher = new CompositeMatcher(META_XPATH.parse("//meta:user-defined/@meta:name"), META_XPATH.parse("//meta:user-defined//text()"));
        MatchingContentHandler matchingContentHandler = new MatchingContentHandler(new AttributeDependantMetadataHandler(metadata, "meta:name", "custom:"), compositeMatcher);
        return new TeeContentHandler(contentHandler, matchingContentHandler);
    }

    @Deprecated
    private static ContentHandler getStatistic(ContentHandler contentHandler, Metadata metadata, String string, String string2) {
        Matcher matcher = META_XPATH.parse("//meta:document-statistic/@meta:" + string2);
        MatchingContentHandler matchingContentHandler = new MatchingContentHandler(new AttributeMetadataHandler(META_NS, string2, metadata, string), matcher);
        return new TeeContentHandler(contentHandler, matchingContentHandler);
    }

    private static ContentHandler getStatistic(ContentHandler contentHandler, Metadata metadata, Property property, String string) {
        Matcher matcher = META_XPATH.parse("//meta:document-statistic/@meta:" + string);
        MatchingContentHandler matchingContentHandler = new MatchingContentHandler(new AttributeMetadataHandler(META_NS, string, metadata, property), matcher);
        return new TeeContentHandler(contentHandler, matchingContentHandler);
    }

    @Override
    protected ContentHandler getContentHandler(ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) {
        contentHandler = new TeeContentHandler(super.getContentHandler(contentHandler, metadata, parseContext), OpenDocumentMetaParser.getDublinCoreHandler(metadata, TikaCoreProperties.TITLE, "title"), OpenDocumentMetaParser.getDublinCoreHandler(metadata, TikaCoreProperties.CREATOR, "creator"), OpenDocumentMetaParser.getDublinCoreHandler(metadata, TikaCoreProperties.DESCRIPTION, "description"), OpenDocumentMetaParser.getDublinCoreHandler(metadata, TikaCoreProperties.PUBLISHER, "publisher"), OpenDocumentMetaParser.getDublinCoreHandler(metadata, TikaCoreProperties.CONTRIBUTOR, "contributor"), OpenDocumentMetaParser.getDublinCoreHandler(metadata, TikaCoreProperties.TYPE, "type"), OpenDocumentMetaParser.getDublinCoreHandler(metadata, TikaCoreProperties.FORMAT, "format"), OpenDocumentMetaParser.getDublinCoreHandler(metadata, TikaCoreProperties.IDENTIFIER, "identifier"), OpenDocumentMetaParser.getDublinCoreHandler(metadata, TikaCoreProperties.LANGUAGE, "language"), OpenDocumentMetaParser.getDublinCoreHandler(metadata, TikaCoreProperties.RIGHTS, "rights"));
        contentHandler = OpenDocumentMetaParser.getMeta(contentHandler, metadata, TikaCoreProperties.CREATED, "creation-date");
        contentHandler = new TeeContentHandler(contentHandler, new ElementMetadataHandler("http://purl.org/dc/elements/1.1/", "date", metadata, TikaCoreProperties.MODIFIED));
        contentHandler = new TeeContentHandler(contentHandler, new ElementMetadataHandler("http://purl.org/dc/elements/1.1/", "subject", metadata, TikaCoreProperties.TRANSITION_SUBJECT_TO_OO_SUBJECT));
        contentHandler = OpenDocumentMetaParser.getMeta(contentHandler, metadata, TikaCoreProperties.TRANSITION_KEYWORDS_TO_DC_SUBJECT, "keyword");
        contentHandler = OpenDocumentMetaParser.getMeta(contentHandler, metadata, Property.externalText("Edit-Time"), "editing-duration");
        contentHandler = OpenDocumentMetaParser.getMeta(contentHandler, metadata, Property.externalText("editing-cycles"), "editing-cycles");
        contentHandler = OpenDocumentMetaParser.getMeta(contentHandler, metadata, TRANSITION_INITIAL_CREATOR_TO_INITIAL_AUTHOR, "initial-creator");
        contentHandler = OpenDocumentMetaParser.getMeta(contentHandler, metadata, Property.externalText("generator"), "generator");
        contentHandler = OpenDocumentMetaParser.getUserDefined(contentHandler, metadata);
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, Office.OBJECT_COUNT, "object-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, Office.IMAGE_COUNT, "image-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, Office.PAGE_COUNT, "page-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, PagedText.N_PAGES, "page-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, Office.TABLE_COUNT, "table-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, Office.PARAGRAPH_COUNT, "paragraph-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, Office.WORD_COUNT, "word-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, Office.CHARACTER_COUNT, "character-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, MSOffice.OBJECT_COUNT, "object-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, MSOffice.IMAGE_COUNT, "image-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, MSOffice.PAGE_COUNT, "page-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, MSOffice.TABLE_COUNT, "table-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, MSOffice.PARAGRAPH_COUNT, "paragraph-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, MSOffice.WORD_COUNT, "word-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, MSOffice.CHARACTER_COUNT, "character-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, "nbPage", "page-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, "nbPara", "paragraph-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, "nbWord", "word-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, "nbCharacter", "character-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, "nbTab", "table-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, "nbObject", "object-count");
        contentHandler = OpenDocumentMetaParser.getStatistic(contentHandler, metadata, "nbImg", "image-count");
        contentHandler = new NSNormalizerContentHandler(contentHandler);
        return contentHandler;
    }

    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        super.parse(inputStream, contentHandler, metadata, parseContext);
        String string = metadata.get(OfficeOpenXMLCore.SUBJECT);
        if (string != null && !string.equals("") && (metadata.get(TikaCoreProperties.DESCRIPTION) == null || metadata.get(TikaCoreProperties.DESCRIPTION).equals(""))) {
            metadata.set(TikaCoreProperties.DESCRIPTION, string);
        }
    }
}

