/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.RTFMetadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.rtf.RTFObjDataParser;
import org.apache.tika.parser.rtf.RTFParser;
import org.apache.tika.parser.rtf.TextExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class RTFEmbObjHandler {
    private static final String EMPTY_STRING = "";
    private final ContentHandler handler;
    private final ParseContext context;
    private final ByteArrayOutputStream os;
    private int hi = -1;
    private int thumbCount = 0;
    private AtomicInteger unknownFilenameCount = new AtomicInteger();
    private boolean inObject = false;
    private String sv = "";
    private String sn = "";
    private StringBuilder sb = new StringBuilder();
    private Metadata metadata;
    private EMB_STATE state = EMB_STATE.NADA;

    protected RTFEmbObjHandler(ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) {
        this.handler = contentHandler;
        this.context = parseContext;
        this.os = new ByteArrayOutputStream();
    }

    protected void startPict() {
        this.state = EMB_STATE.PICT;
        this.metadata = new Metadata();
    }

    protected void startObjData() {
        this.state = EMB_STATE.OBJDATA;
        this.metadata = new Metadata();
    }

    protected void startSN() {
        this.sb.setLength(0);
        this.sb.append("rtf_pict:");
    }

    protected void endSN() {
        this.sn = this.sb.toString();
    }

    protected void startSV() {
        this.sb.setLength(0);
    }

    protected void endSV() {
        this.sv = this.sb.toString();
    }

    protected void endSP() {
        this.metadata.add(this.sn, this.sv);
    }

    protected boolean getInObject() {
        return this.inObject;
    }

    protected void setInObject(boolean bl) {
        this.inObject = bl;
    }

    protected void writeMetadataChar(char c) {
        this.sb.append(c);
    }

    protected void writeHexChar(int n) throws IOException, TikaException {
        if (TextExtractor.isHexChar(n)) {
            if (this.hi == -1) {
                this.hi = 16 * TextExtractor.hexValue(n);
            } else {
                long l = this.hi + TextExtractor.hexValue(n);
                if (l > Integer.MAX_VALUE || l < 0L) {
                    throw new IOException("hex char to byte overflow");
                }
                this.os.write((int)l);
                this.hi = -1;
            }
            return;
        }
        if (n == -1) {
            throw new TikaException("hit end of stream before finishing byte pair");
        }
    }

    protected void writeBytes(InputStream inputStream, int n) throws IOException, TikaException {
        if (n < 0 || n > RTFParser.getMaxBytesForEmbeddedObject()) {
            throw new IOException("length of bytes to read out of bounds: " + n);
        }
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 < n) {
            throw new TikaException("unexpected end of file: need " + n + " bytes of binary data, found " + (n - n2));
        }
        this.os.write(byArray);
    }

    protected void handleCompletedObject() throws IOException, SAXException, TikaException {
        EmbeddedDocumentExtractor embeddedDocumentExtractor = this.context.get(EmbeddedDocumentExtractor.class);
        if (embeddedDocumentExtractor == null) {
            embeddedDocumentExtractor = new ParsingEmbeddedDocumentExtractor(this.context);
        }
        byte[] byArray = this.os.toByteArray();
        if (this.state == EMB_STATE.OBJDATA) {
            RTFObjDataParser rTFObjDataParser = new RTFObjDataParser();
            try {
                byte[] byArray2 = rTFObjDataParser.parse(byArray, this.metadata, this.unknownFilenameCount);
                this.extractObj(byArray2, this.handler, embeddedDocumentExtractor, this.metadata);
            }
            catch (IOException iOException) {}
        } else if (this.state == EMB_STATE.PICT) {
            String string = this.metadata.get("rtf_pict:wzDescription");
            if (string != null && string.length() > 0) {
                this.metadata.set("embeddedRelationshipId", string);
                this.metadata.set("resourceName", FilenameUtils.getName((String)string));
            }
            this.metadata.set(RTFMetadata.THUMBNAIL, Boolean.toString(this.inObject));
            this.extractObj(byArray, this.handler, embeddedDocumentExtractor, this.metadata);
        } else if (this.state == EMB_STATE.NADA) {
            // empty if block
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractObj(byte[] byArray, ContentHandler contentHandler, EmbeddedDocumentExtractor embeddedDocumentExtractor, Metadata metadata) throws SAXException, IOException, TikaException {
        if (byArray == null) {
            return;
        }
        metadata.set("Content-Length", Integer.toString(byArray.length));
        if (embeddedDocumentExtractor.shouldParseEmbedded(metadata)) {
            TikaInputStream tikaInputStream = TikaInputStream.get(byArray);
            if (metadata.get("resourceName") == null) {
                String string = this.getExtension(tikaInputStream, metadata);
                tikaInputStream.reset();
                if (this.inObject && this.state == EMB_STATE.PICT) {
                    metadata.set("resourceName", "thumbnail_" + this.thumbCount++ + string);
                    metadata.set(RTFMetadata.THUMBNAIL, "true");
                } else {
                    metadata.set("resourceName", "file_" + this.unknownFilenameCount.getAndIncrement() + string);
                }
            }
            try {
                embeddedDocumentExtractor.parseEmbedded(tikaInputStream, new EmbeddedContentHandler(contentHandler), metadata, false);
            }
            finally {
                tikaInputStream.close();
            }
        }
    }

    private String getExtension(TikaInputStream tikaInputStream, Metadata metadata) {
        String string = metadata.get("Content-Type");
        TikaConfig tikaConfig = this.getConfig();
        if (string == null) {
            Detector detector = tikaConfig.getDetector();
            try {
                MediaType mediaType = detector.detect(tikaInputStream, metadata);
                MimeTypes mimeTypes = tikaConfig.getMimeRepository();
                MimeType mimeType = mimeTypes.forName(mediaType.toString());
                metadata.set("Content-Type", mimeType.toString());
                return mimeType.getExtension();
            }
            catch (IOException iOException) {
            }
            catch (MimeTypeException mimeTypeException) {
                // empty catch block
            }
        }
        return ".bin";
    }

    private TikaConfig getConfig() {
        TikaConfig tikaConfig = this.context.get(TikaConfig.class);
        if (tikaConfig == null) {
            tikaConfig = TikaConfig.getDefaultConfig();
        }
        return tikaConfig;
    }

    protected void reset() {
        this.state = EMB_STATE.NADA;
        this.os.reset();
        this.metadata = new Metadata();
        this.hi = -1;
        this.sv = EMPTY_STRING;
        this.sn = EMPTY_STRING;
        this.sb.setLength(0);
    }

    private static enum EMB_STATE {
        PICT,
        OBJDATA,
        NADA;

    }
}

