/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.input.TaggedInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.rtf.RTFEmbObjHandler;
import org.apache.tika.parser.rtf.TextExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RTFParser
extends AbstractParser {
    private static final long serialVersionUID = -4165069489372320313L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application("rtf"));
    private static int EMB_OBJ_MAX_BYTES = 0x1400000;

    public static int getMaxBytesForEmbeddedObject() {
        return EMB_OBJ_MAX_BYTES;
    }

    public static void setMaxBytesForEmbeddedObject(int n) {
        EMB_OBJ_MAX_BYTES = n;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", "application/rtf");
        TaggedInputStream taggedInputStream = new TaggedInputStream(inputStream);
        try {
            XHTMLContentHandler xHTMLContentHandler = new XHTMLContentHandler(contentHandler, metadata);
            RTFEmbObjHandler rTFEmbObjHandler = new RTFEmbObjHandler(xHTMLContentHandler, metadata, parseContext);
            TextExtractor textExtractor = new TextExtractor(xHTMLContentHandler, metadata, rTFEmbObjHandler);
            textExtractor.extract(inputStream);
        }
        catch (IOException iOException) {
            taggedInputStream.throwIfCauseOf((Throwable)iOException);
            throw new TikaException("Error parsing an RTF document", iOException);
        }
    }
}

