/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.util.Arrays;
import java.util.List;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.xml.sax.helpers.DefaultHandler;

class AbstractMetadataHandler
extends DefaultHandler {
    private final Metadata metadata;
    private final Property property;
    private final String name;

    protected AbstractMetadataHandler(Metadata metadata, String string) {
        this.metadata = metadata;
        this.property = null;
        this.name = string;
    }

    protected AbstractMetadataHandler(Metadata metadata, Property property) {
        this.metadata = metadata;
        this.property = property;
        this.name = property.getName();
    }

    protected void addMetadata(String string) {
        if (string != null && string.length() > 0) {
            if (this.metadata.isMultiValued(this.name)) {
                List<String> list = Arrays.asList(this.metadata.getValues(this.name));
                if (!list.contains(string)) {
                    if (this.property != null) {
                        this.metadata.add(this.property, string);
                    } else {
                        this.metadata.add(this.name, string);
                    }
                }
            } else {
                String string2 = this.metadata.get(this.name);
                if (string2 != null && string2.length() > 0) {
                    if (!string2.equals(string)) {
                        if (this.property != null) {
                            if (this.property.isMultiValuePermitted()) {
                                this.metadata.add(this.property, string);
                            } else {
                                this.metadata.set(this.property, string);
                            }
                        } else {
                            this.metadata.add(this.name, string);
                        }
                    }
                } else if (this.property != null) {
                    this.metadata.set(this.property, string);
                } else {
                    this.metadata.set(this.name, string);
                }
            }
        }
    }
}

