/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataHandler
extends DefaultHandler {
    private final Metadata metadata;
    private final Property property;
    private final String name;
    private final StringBuilder buffer = new StringBuilder();

    public MetadataHandler(Metadata metadata, String string) {
        this.metadata = metadata;
        this.property = null;
        this.name = string;
    }

    public MetadataHandler(Metadata metadata, Property property) {
        this.metadata = metadata;
        this.property = property;
        this.name = property.getName();
    }

    public void addMetadata(String object) {
        if (((String)object).length() > 0) {
            String string = this.metadata.get(this.name);
            if (string != null && string.length() > 0) {
                object = string + ", " + (String)object;
            }
            if (this.property != null) {
                this.metadata.set(this.property, (String)object);
            } else {
                this.metadata.set(this.name, (String)object);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.addMetadata(this.buffer.toString());
        this.buffer.setLength(0);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.addMetadata(attributes.getValue(i));
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.buffer.append(cArray, n, n2);
    }
}

