/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ElementMappingContentHandler
extends ContentHandlerDecorator {
    private final Map<QName, TargetElement> mappings;

    public ElementMappingContentHandler(ContentHandler contentHandler, Map<QName, TargetElement> map) {
        super(contentHandler);
        this.mappings = map;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        TargetElement targetElement = this.mappings.get(new QName(string, string2));
        if (targetElement != null) {
            QName qName = targetElement.getMappedTagName();
            super.startElement(qName.getNamespaceURI(), qName.getLocalPart(), ElementMappingContentHandler.getQNameAsString(qName), targetElement.mapAttributes(attributes));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        TargetElement targetElement = this.mappings.get(new QName(string, string2));
        if (targetElement != null) {
            QName qName = targetElement.getMappedTagName();
            super.endElement(qName.getNamespaceURI(), qName.getLocalPart(), ElementMappingContentHandler.getQNameAsString(qName));
        }
    }

    protected static final String getQNameAsString(QName qName) {
        String string = qName.getPrefix();
        if (string.length() > 0) {
            return string + ":" + qName.getLocalPart();
        }
        return qName.getLocalPart();
    }

    public static class TargetElement {
        private final QName mappedTagName;
        private final Map<QName, QName> attributesMapping;

        public TargetElement(QName qName, Map<QName, QName> map) {
            this.mappedTagName = qName;
            this.attributesMapping = map;
        }

        public TargetElement(String string, String string2, Map<QName, QName> map) {
            this(new QName(string, string2), map);
        }

        public TargetElement(QName qName) {
            this(qName, Collections.emptyMap());
        }

        public TargetElement(String string, String string2) {
            this(string, string2, Collections.emptyMap());
        }

        public QName getMappedTagName() {
            return this.mappedTagName;
        }

        public Map<QName, QName> getAttributesMapping() {
            return this.attributesMapping;
        }

        public Attributes mapAttributes(Attributes attributes) {
            AttributesImpl attributesImpl = new AttributesImpl();
            for (int i = 0; i < attributes.getLength(); ++i) {
                QName qName = this.attributesMapping.get(new QName(attributes.getURI(i), attributes.getLocalName(i)));
                if (qName == null) continue;
                attributesImpl.addAttribute(qName.getNamespaceURI(), qName.getLocalPart(), ElementMappingContentHandler.getQNameAsString(qName), attributes.getType(i), attributes.getValue(i));
            }
            return attributesImpl;
        }
    }
}

