/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

public class Link {
    private final String type;
    private final String uri;
    private final String title;
    private final String text;
    private final String rel;

    public Link(String string, String string2, String string3, String string4) {
        this.type = string;
        this.uri = string2;
        this.title = string3;
        this.text = string4;
        this.rel = "";
    }

    public Link(String string, String string2, String string3, String string4, String string5) {
        this.type = string;
        this.uri = string2;
        this.title = string3;
        this.text = string4;
        this.rel = string5;
    }

    public boolean isAnchor() {
        return "a".equals(this.type);
    }

    public boolean isImage() {
        return "img".equals(this.type);
    }

    public boolean isLink() {
        return "link".equals(this.type);
    }

    public boolean isIframe() {
        return "iframe".equals(this.type);
    }

    public boolean isScript() {
        return "script".equals(this.type);
    }

    public String getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public String getRel() {
        return this.rel;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isImage()) {
            stringBuilder.append("<img src=\"");
            stringBuilder.append(this.uri);
            if (this.title != null && this.title.length() > 0) {
                stringBuilder.append("\" title=\"");
                stringBuilder.append(this.title);
            }
            if (this.text != null && this.text.length() > 0) {
                stringBuilder.append("\" alt=\"");
                stringBuilder.append(this.text);
            }
            stringBuilder.append("\"/>");
        } else {
            stringBuilder.append("<");
            stringBuilder.append(this.type);
            stringBuilder.append(" href=\"");
            stringBuilder.append(this.uri);
            if (this.title != null && this.title.length() > 0) {
                stringBuilder.append("\" title=\"");
                stringBuilder.append(this.title);
            }
            if (this.rel != null && this.rel.length() > 0) {
                stringBuilder.append("\" rel=\"");
                stringBuilder.append(this.rel);
            }
            stringBuilder.append("\">");
            stringBuilder.append(this.text);
            stringBuilder.append("</");
            stringBuilder.append(this.type);
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }
}

