/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ToTextContentHandler
extends DefaultHandler {
    private final Writer writer;

    public ToTextContentHandler(Writer writer) {
        this.writer = writer;
    }

    public ToTextContentHandler(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream, Charset.defaultCharset()));
    }

    public ToTextContentHandler(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(outputStream, string));
    }

    public ToTextContentHandler() {
        this(new StringWriter());
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writer.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException("Error writing: " + new String(cArray, n, n2), iOException);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("Error flushing character output", iOException);
        }
    }

    public String toString() {
        return this.writer.toString();
    }
}

