/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.tika.sax.ToTextContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToXMLContentHandler
extends ToTextContentHandler {
    private final String encoding;
    protected boolean inStartElement = false;
    protected final Map<String, String> namespaces = new HashMap<String, String>();
    private ElementInfo currentElement;

    public ToXMLContentHandler(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
        this.encoding = string;
    }

    public ToXMLContentHandler(String string) {
        this.encoding = string;
    }

    public ToXMLContentHandler() {
        this.encoding = null;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.encoding != null) {
            this.write("<?xml version=\"1.0\" encoding=\"");
            this.write(this.encoding);
            this.write("\"?>\n");
        }
        this.currentElement = null;
        this.namespaces.clear();
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        try {
            if (this.currentElement != null && string.equals(this.currentElement.getPrefix(string2))) {
                return;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        this.namespaces.put(string2, string);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.lazyCloseStartElement();
        this.currentElement = new ElementInfo(this.currentElement, this.namespaces);
        this.write('<');
        this.write(this.currentElement.getQName(string, string2));
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.write(' ');
            this.write(this.currentElement.getQName(attributes.getURI(i), attributes.getLocalName(i)));
            this.write('=');
            this.write('\"');
            char[] object = attributes.getValue(i).toCharArray();
            this.writeEscaped(object, 0, object.length, true);
            this.write('\"');
        }
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            this.write(' ');
            this.write("xmlns");
            String string4 = entry.getValue();
            if (string4.length() > 0) {
                this.write(':');
                this.write(string4);
            }
            this.write('=');
            this.write('\"');
            char[] cArray = entry.getKey().toCharArray();
            this.writeEscaped(cArray, 0, cArray.length, true);
            this.write('\"');
        }
        this.namespaces.clear();
        this.inStartElement = true;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.inStartElement) {
            this.write(" />");
            this.inStartElement = false;
        } else {
            this.write("</");
            this.write(string3);
            this.write('>');
        }
        this.namespaces.clear();
        this.currentElement = this.currentElement.parent;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.lazyCloseStartElement();
        this.writeEscaped(cArray, n, n + n2, false);
    }

    private void lazyCloseStartElement() throws SAXException {
        if (this.inStartElement) {
            this.write('>');
            this.inStartElement = false;
        }
    }

    protected void write(char c) throws SAXException {
        super.characters(new char[]{c}, 0, 1);
    }

    protected void write(String string) throws SAXException {
        super.characters(string.toCharArray(), 0, string.length());
    }

    private int writeCharsAndEntity(char[] cArray, int n, int n2, String string) throws SAXException {
        super.characters(cArray, n, n2 - n);
        this.write('&');
        this.write(string);
        this.write(';');
        return n2 + 1;
    }

    private void writeEscaped(char[] cArray, int n, int n2, boolean bl) throws SAXException {
        int n3 = n;
        while (n3 < n2) {
            if (cArray[n3] == '<') {
                n = n3 = this.writeCharsAndEntity(cArray, n, n3, "lt");
                continue;
            }
            if (cArray[n3] == '>') {
                n = n3 = this.writeCharsAndEntity(cArray, n, n3, "gt");
                continue;
            }
            if (cArray[n3] == '&') {
                n = n3 = this.writeCharsAndEntity(cArray, n, n3, "amp");
                continue;
            }
            if (bl && cArray[n3] == '\"') {
                n = n3 = this.writeCharsAndEntity(cArray, n, n3, "quot");
                continue;
            }
            ++n3;
        }
        super.characters(cArray, n, n2 - n);
    }

    private static class ElementInfo {
        private final ElementInfo parent;
        private final Map<String, String> namespaces;

        public ElementInfo(ElementInfo elementInfo, Map<String, String> map) {
            this.parent = elementInfo;
            this.namespaces = map.isEmpty() ? Collections.emptyMap() : new HashMap<String, String>(map);
        }

        public String getPrefix(String string) throws SAXException {
            String string2 = this.namespaces.get(string);
            if (string2 != null) {
                return string2;
            }
            if (this.parent != null) {
                return this.parent.getPrefix(string);
            }
            if (string == null || string.length() == 0) {
                return "";
            }
            throw new SAXException("Namespace " + string + " not declared");
        }

        public String getQName(String string, String string2) throws SAXException {
            String string3 = this.getPrefix(string);
            if (string3.length() > 0) {
                return string3 + ":" + string2;
            }
            return string2;
        }
    }
}

