/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.sax.ToTextContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WriteOutContentHandler
extends ContentHandlerDecorator {
    private final Serializable tag = UUID.randomUUID();
    private final int writeLimit;
    private int writeCount = 0;

    public WriteOutContentHandler(ContentHandler contentHandler, int n) {
        super(contentHandler);
        this.writeLimit = n;
    }

    public WriteOutContentHandler(Writer writer, int n) {
        this(new ToTextContentHandler(writer), n);
    }

    public WriteOutContentHandler(Writer writer) {
        this(writer, -1);
    }

    public WriteOutContentHandler(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream, Charset.defaultCharset()));
    }

    public WriteOutContentHandler(int n) {
        this(new StringWriter(), n);
    }

    public WriteOutContentHandler() {
        this(100000);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.writeLimit == -1 || this.writeCount + n2 <= this.writeLimit) {
            super.characters(cArray, n, n2);
            this.writeCount += n2;
        } else {
            super.characters(cArray, n, this.writeLimit - this.writeCount);
            this.writeCount = this.writeLimit;
            throw new WriteLimitReachedException("Your document contained more than " + this.writeLimit + " characters, and so your requested limit has been reached. To receive the full text of the document, increase your limit. (Text up to the limit is however available).", this.tag);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.writeLimit == -1 || this.writeCount + n2 <= this.writeLimit) {
            super.ignorableWhitespace(cArray, n, n2);
            this.writeCount += n2;
        } else {
            super.ignorableWhitespace(cArray, n, this.writeLimit - this.writeCount);
            this.writeCount = this.writeLimit;
            throw new WriteLimitReachedException("Your document contained more than " + this.writeLimit + " characters, and so your requested limit has been reached. To receive the full text of the document, increase your limit. (Text up to the limit is however available).", this.tag);
        }
    }

    public boolean isWriteLimitReached(Throwable throwable) {
        if (throwable instanceof WriteLimitReachedException) {
            return this.tag.equals(((WriteLimitReachedException)throwable).tag);
        }
        return throwable.getCause() != null && this.isWriteLimitReached(throwable.getCause());
    }

    private static class WriteLimitReachedException
    extends SAXException {
        private static final long serialVersionUID = -1850581945459429943L;
        private final Serializable tag;

        public WriteLimitReachedException(String string, Serializable serializable) {
            super(string);
            this.tag = serializable;
        }
    }
}

