/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.sax.SafeContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XHTMLContentHandler
extends SafeContentHandler {
    public static final String XHTML = "http://www.w3.org/1999/xhtml";
    private static final char[] NL = new char[]{'\n'};
    private static final char[] TAB = new char[]{'\t'};
    private static final Set<String> HEAD = XHTMLContentHandler.unmodifiableSet("title", "link", "base", "meta");
    private static final Set<String> AUTO = XHTMLContentHandler.unmodifiableSet("head", "frameset");
    private static final Set<String> INDENT = XHTMLContentHandler.unmodifiableSet("li", "dd", "dt", "td", "th", "frame");
    public static final Set<String> ENDLINE = XHTMLContentHandler.unmodifiableSet("p", "h1", "h2", "h3", "h4", "h5", "h6", "div", "ul", "ol", "dl", "pre", "hr", "blockquote", "address", "fieldset", "table", "form", "noscript", "li", "dt", "dd", "noframes", "br", "tr", "select", "option");
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private final Metadata metadata;
    private boolean documentStarted = false;
    private boolean headStarted = false;
    private boolean headEnded = false;
    private boolean useFrameset = false;

    private static Set<String> unmodifiableSet(String ... stringArray) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(stringArray)));
    }

    public XHTMLContentHandler(ContentHandler contentHandler, Metadata metadata) {
        super(contentHandler);
        this.metadata = metadata;
    }

    @Override
    public void startDocument() throws SAXException {
        if (!this.documentStarted) {
            this.documentStarted = true;
            super.startDocument();
            this.startPrefixMapping("", XHTML);
        }
    }

    private void lazyStartHead() throws SAXException {
        if (!this.headStarted) {
            this.headStarted = true;
            super.startElement(XHTML, "html", "html", EMPTY_ATTRIBUTES);
            this.newline();
            super.startElement(XHTML, "head", "head", EMPTY_ATTRIBUTES);
            this.newline();
        }
    }

    private void lazyEndHead(boolean bl) throws SAXException {
        this.lazyStartHead();
        if (!this.headEnded) {
            this.headEnded = true;
            this.useFrameset = bl;
            for (String string : this.metadata.names()) {
                if (string.equals("title")) continue;
                for (String string2 : this.metadata.getValues(string)) {
                    if (string2 == null) continue;
                    AttributesImpl attributesImpl = new AttributesImpl();
                    attributesImpl.addAttribute("", "name", "name", "CDATA", string);
                    attributesImpl.addAttribute("", "content", "content", "CDATA", string2);
                    super.startElement(XHTML, "meta", "meta", attributesImpl);
                    super.endElement(XHTML, "meta", "meta");
                    this.newline();
                }
            }
            super.startElement(XHTML, "title", "title", EMPTY_ATTRIBUTES);
            String string = this.metadata.get(TikaCoreProperties.TITLE);
            if (string != null && string.length() > 0) {
                char[] cArray = string.toCharArray();
                super.characters(cArray, 0, cArray.length);
            } else {
                super.characters(new char[0], 0, 0);
            }
            super.endElement(XHTML, "title", "title");
            this.newline();
            super.endElement(XHTML, "head", "head");
            this.newline();
            if (this.useFrameset) {
                super.startElement(XHTML, "frameset", "frameset", EMPTY_ATTRIBUTES);
            } else {
                super.startElement(XHTML, "body", "body", EMPTY_ATTRIBUTES);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.lazyEndHead(this.useFrameset);
        if (this.useFrameset) {
            super.endElement(XHTML, "frameset", "frameset");
        } else {
            super.endElement(XHTML, "body", "body");
        }
        super.endElement(XHTML, "html", "html");
        this.endPrefixMapping("");
        super.endDocument();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("frameset")) {
            this.lazyEndHead(true);
        } else if (!AUTO.contains(string3)) {
            if (HEAD.contains(string3)) {
                this.lazyStartHead();
            } else {
                this.lazyEndHead(false);
            }
            if (XHTML.equals(string) && INDENT.contains(string3)) {
                this.ignorableWhitespace(TAB, 0, TAB.length);
            }
            super.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!AUTO.contains(string3)) {
            super.endElement(string, string2, string3);
            if (XHTML.equals(string) && ENDLINE.contains(string3)) {
                this.newline();
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.lazyEndHead(this.useFrameset);
        super.characters(cArray, n, n2);
    }

    public void startElement(String string) throws SAXException {
        this.startElement(XHTML, string, string, EMPTY_ATTRIBUTES);
    }

    public void startElement(String string, String string2, String string3) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", string2, string2, "CDATA", string3);
        this.startElement(XHTML, string, string, attributesImpl);
    }

    public void startElement(String string, AttributesImpl attributesImpl) throws SAXException {
        this.startElement(XHTML, string, string, attributesImpl);
    }

    public void endElement(String string) throws SAXException {
        this.endElement(XHTML, string, string);
    }

    public void characters(String string) throws SAXException {
        if (string != null && string.length() > 0) {
            this.characters(string.toCharArray(), 0, string.length());
        }
    }

    public void newline() throws SAXException {
        this.ignorableWhitespace(NL, 0, NL.length);
    }

    public void element(String string, String string2) throws SAXException {
        if (string2 != null && string2.length() > 0) {
            this.startElement(string);
            this.characters(string2);
            this.endElement(string);
        }
    }
}

