/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.sax.SafeContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMPContentHandler
extends SafeContentHandler {
    public static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String XMP = "http://ns.adobe.com/xap/1.0/";
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private String prefix = null;
    private String uri = null;

    public XMPContentHandler(ContentHandler contentHandler) {
        super(contentHandler);
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.startPrefixMapping("rdf", RDF);
        this.startPrefixMapping("xmp", XMP);
        this.startElement(RDF, "RDF", "rdf:RDF", EMPTY_ATTRIBUTES);
    }

    @Override
    public void endDocument() throws SAXException {
        this.endElement(RDF, "RDF", "rdf:RDF");
        this.endPrefixMapping("xmp");
        this.endPrefixMapping("rdf");
        super.endDocument();
    }

    public void startDescription(String string, String string2, String string3) throws SAXException {
        this.prefix = string2;
        this.uri = string3;
        this.startPrefixMapping(string2, string3);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute(RDF, "about", "rdf:about", "CDATA", string);
        this.startElement(RDF, "Description", "rdf:Description", attributesImpl);
    }

    public void endDescription() throws SAXException {
        this.endElement(RDF, "Description", "rdf:Description");
        this.endPrefixMapping(this.prefix);
        this.uri = null;
        this.prefix = null;
    }

    public void property(String string, String string2) throws SAXException {
        String string3 = this.prefix + ":" + string;
        this.startElement(this.uri, string, string3, EMPTY_ATTRIBUTES);
        this.characters(string2.toCharArray(), 0, string2.length());
        this.endElement(this.uri, string, string3);
    }

    public void metadata(Metadata metadata) throws SAXException {
        this.description(metadata, "xmp", XMP);
        this.description(metadata, "dc", "http://purl.org/dc/elements/1.1/");
        this.description(metadata, "xmpTPg", "http://ns.adobe.com/xap/1.0/t/pg/");
        this.description(metadata, "xmpRigths", "http://ns.adobe.com/xap/1.0/rights/");
        this.description(metadata, "xmpMM", "http://ns.adobe.com/xap/1.0/mm/");
        this.description(metadata, "xmpidq", "http://ns.adobe.com/xmp/identifier/qual/1.0/");
        this.description(metadata, "xmpBJ", "http://ns.adobe.com/xap/1.0/bj/");
        this.description(metadata, "xmpDM", "http://ns.adobe.com/xmp/1.0/DynamicMedia/");
        this.description(metadata, "pdf", "http://ns.adobe.com/pdf/1.3/");
        this.description(metadata, "photoshop", "s http://ns.adobe.com/photoshop/1.0/");
        this.description(metadata, "crs", "http://ns.adobe.com/camera-raw-settings/1.0/");
        this.description(metadata, "tiff", "http://ns.adobe.com/tiff/1.0/");
        this.description(metadata, "exif", "http://ns.adobe.com/exif/1.0/");
        this.description(metadata, "aux", "http://ns.adobe.com/exif/1.0/aux/");
    }

    private void description(Metadata metadata, String string, String string2) throws SAXException {
        int n = 0;
        for (Property property : Property.getProperties(string)) {
            String string3 = metadata.get(property);
            if (string3 == null) continue;
            if (n++ == 0) {
                this.startDescription("", string, string2);
            }
            this.property(property.getName().substring(string.length() + 1), string3);
        }
        if (n > 0) {
            this.endDescription();
        }
    }
}

